// Code generated by go-swagger; DO NOT EDIT.

package sensor_visibility_exclusions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateSensorVisibilityExclusionsV1Reader is a Reader for the UpdateSensorVisibilityExclusionsV1 structure.
type UpdateSensorVisibilityExclusionsV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateSensorVisibilityExclusionsV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateSensorVisibilityExclusionsV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateSensorVisibilityExclusionsV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateSensorVisibilityExclusionsV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateSensorVisibilityExclusionsV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateSensorVisibilityExclusionsV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /policy/entities/sv-exclusions/v1] updateSensorVisibilityExclusionsV1", response, response.Code())
	}
}

// NewUpdateSensorVisibilityExclusionsV1OK creates a UpdateSensorVisibilityExclusionsV1OK with default headers values
func NewUpdateSensorVisibilityExclusionsV1OK() *UpdateSensorVisibilityExclusionsV1OK {
	return &UpdateSensorVisibilityExclusionsV1OK{}
}

/*
UpdateSensorVisibilityExclusionsV1OK describes a response with status code 200, with default header values.

OK
*/
type UpdateSensorVisibilityExclusionsV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SvExclusionsRespV1
}

// IsSuccess returns true when this update sensor visibility exclusions v1 o k response has a 2xx status code
func (o *UpdateSensorVisibilityExclusionsV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update sensor visibility exclusions v1 o k response has a 3xx status code
func (o *UpdateSensorVisibilityExclusionsV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update sensor visibility exclusions v1 o k response has a 4xx status code
func (o *UpdateSensorVisibilityExclusionsV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update sensor visibility exclusions v1 o k response has a 5xx status code
func (o *UpdateSensorVisibilityExclusionsV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this update sensor visibility exclusions v1 o k response a status code equal to that given
func (o *UpdateSensorVisibilityExclusionsV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update sensor visibility exclusions v1 o k response
func (o *UpdateSensorVisibilityExclusionsV1OK) Code() int {
	return 200
}

func (o *UpdateSensorVisibilityExclusionsV1OK) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/sv-exclusions/v1][%d] updateSensorVisibilityExclusionsV1OK  %+v", 200, o.Payload)
}

func (o *UpdateSensorVisibilityExclusionsV1OK) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/sv-exclusions/v1][%d] updateSensorVisibilityExclusionsV1OK  %+v", 200, o.Payload)
}

func (o *UpdateSensorVisibilityExclusionsV1OK) GetPayload() *models.SvExclusionsRespV1 {
	return o.Payload
}

func (o *UpdateSensorVisibilityExclusionsV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SvExclusionsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateSensorVisibilityExclusionsV1BadRequest creates a UpdateSensorVisibilityExclusionsV1BadRequest with default headers values
func NewUpdateSensorVisibilityExclusionsV1BadRequest() *UpdateSensorVisibilityExclusionsV1BadRequest {
	return &UpdateSensorVisibilityExclusionsV1BadRequest{}
}

/*
UpdateSensorVisibilityExclusionsV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateSensorVisibilityExclusionsV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SvExclusionsRespV1
}

// IsSuccess returns true when this update sensor visibility exclusions v1 bad request response has a 2xx status code
func (o *UpdateSensorVisibilityExclusionsV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update sensor visibility exclusions v1 bad request response has a 3xx status code
func (o *UpdateSensorVisibilityExclusionsV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update sensor visibility exclusions v1 bad request response has a 4xx status code
func (o *UpdateSensorVisibilityExclusionsV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update sensor visibility exclusions v1 bad request response has a 5xx status code
func (o *UpdateSensorVisibilityExclusionsV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update sensor visibility exclusions v1 bad request response a status code equal to that given
func (o *UpdateSensorVisibilityExclusionsV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update sensor visibility exclusions v1 bad request response
func (o *UpdateSensorVisibilityExclusionsV1BadRequest) Code() int {
	return 400
}

func (o *UpdateSensorVisibilityExclusionsV1BadRequest) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/sv-exclusions/v1][%d] updateSensorVisibilityExclusionsV1BadRequest  %+v", 400, o.Payload)
}

func (o *UpdateSensorVisibilityExclusionsV1BadRequest) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/sv-exclusions/v1][%d] updateSensorVisibilityExclusionsV1BadRequest  %+v", 400, o.Payload)
}

func (o *UpdateSensorVisibilityExclusionsV1BadRequest) GetPayload() *models.SvExclusionsRespV1 {
	return o.Payload
}

func (o *UpdateSensorVisibilityExclusionsV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SvExclusionsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateSensorVisibilityExclusionsV1Forbidden creates a UpdateSensorVisibilityExclusionsV1Forbidden with default headers values
func NewUpdateSensorVisibilityExclusionsV1Forbidden() *UpdateSensorVisibilityExclusionsV1Forbidden {
	return &UpdateSensorVisibilityExclusionsV1Forbidden{}
}

/*
UpdateSensorVisibilityExclusionsV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateSensorVisibilityExclusionsV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this update sensor visibility exclusions v1 forbidden response has a 2xx status code
func (o *UpdateSensorVisibilityExclusionsV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update sensor visibility exclusions v1 forbidden response has a 3xx status code
func (o *UpdateSensorVisibilityExclusionsV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update sensor visibility exclusions v1 forbidden response has a 4xx status code
func (o *UpdateSensorVisibilityExclusionsV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update sensor visibility exclusions v1 forbidden response has a 5xx status code
func (o *UpdateSensorVisibilityExclusionsV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update sensor visibility exclusions v1 forbidden response a status code equal to that given
func (o *UpdateSensorVisibilityExclusionsV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update sensor visibility exclusions v1 forbidden response
func (o *UpdateSensorVisibilityExclusionsV1Forbidden) Code() int {
	return 403
}

func (o *UpdateSensorVisibilityExclusionsV1Forbidden) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/sv-exclusions/v1][%d] updateSensorVisibilityExclusionsV1Forbidden  %+v", 403, o.Payload)
}

func (o *UpdateSensorVisibilityExclusionsV1Forbidden) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/sv-exclusions/v1][%d] updateSensorVisibilityExclusionsV1Forbidden  %+v", 403, o.Payload)
}

func (o *UpdateSensorVisibilityExclusionsV1Forbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *UpdateSensorVisibilityExclusionsV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateSensorVisibilityExclusionsV1TooManyRequests creates a UpdateSensorVisibilityExclusionsV1TooManyRequests with default headers values
func NewUpdateSensorVisibilityExclusionsV1TooManyRequests() *UpdateSensorVisibilityExclusionsV1TooManyRequests {
	return &UpdateSensorVisibilityExclusionsV1TooManyRequests{}
}

/*
UpdateSensorVisibilityExclusionsV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateSensorVisibilityExclusionsV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update sensor visibility exclusions v1 too many requests response has a 2xx status code
func (o *UpdateSensorVisibilityExclusionsV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update sensor visibility exclusions v1 too many requests response has a 3xx status code
func (o *UpdateSensorVisibilityExclusionsV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update sensor visibility exclusions v1 too many requests response has a 4xx status code
func (o *UpdateSensorVisibilityExclusionsV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update sensor visibility exclusions v1 too many requests response has a 5xx status code
func (o *UpdateSensorVisibilityExclusionsV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update sensor visibility exclusions v1 too many requests response a status code equal to that given
func (o *UpdateSensorVisibilityExclusionsV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update sensor visibility exclusions v1 too many requests response
func (o *UpdateSensorVisibilityExclusionsV1TooManyRequests) Code() int {
	return 429
}

func (o *UpdateSensorVisibilityExclusionsV1TooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/sv-exclusions/v1][%d] updateSensorVisibilityExclusionsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateSensorVisibilityExclusionsV1TooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/sv-exclusions/v1][%d] updateSensorVisibilityExclusionsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateSensorVisibilityExclusionsV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateSensorVisibilityExclusionsV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateSensorVisibilityExclusionsV1InternalServerError creates a UpdateSensorVisibilityExclusionsV1InternalServerError with default headers values
func NewUpdateSensorVisibilityExclusionsV1InternalServerError() *UpdateSensorVisibilityExclusionsV1InternalServerError {
	return &UpdateSensorVisibilityExclusionsV1InternalServerError{}
}

/*
UpdateSensorVisibilityExclusionsV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UpdateSensorVisibilityExclusionsV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SvExclusionsRespV1
}

// IsSuccess returns true when this update sensor visibility exclusions v1 internal server error response has a 2xx status code
func (o *UpdateSensorVisibilityExclusionsV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update sensor visibility exclusions v1 internal server error response has a 3xx status code
func (o *UpdateSensorVisibilityExclusionsV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update sensor visibility exclusions v1 internal server error response has a 4xx status code
func (o *UpdateSensorVisibilityExclusionsV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update sensor visibility exclusions v1 internal server error response has a 5xx status code
func (o *UpdateSensorVisibilityExclusionsV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update sensor visibility exclusions v1 internal server error response a status code equal to that given
func (o *UpdateSensorVisibilityExclusionsV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update sensor visibility exclusions v1 internal server error response
func (o *UpdateSensorVisibilityExclusionsV1InternalServerError) Code() int {
	return 500
}

func (o *UpdateSensorVisibilityExclusionsV1InternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/sv-exclusions/v1][%d] updateSensorVisibilityExclusionsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateSensorVisibilityExclusionsV1InternalServerError) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/sv-exclusions/v1][%d] updateSensorVisibilityExclusionsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateSensorVisibilityExclusionsV1InternalServerError) GetPayload() *models.SvExclusionsRespV1 {
	return o.Payload
}

func (o *UpdateSensorVisibilityExclusionsV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SvExclusionsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
