// Code generated by go-swagger; DO NOT EDIT.

package tailored_intelligence

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryRulesParams creates a new QueryRulesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryRulesParams() *QueryRulesParams {
	return &QueryRulesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryRulesParamsWithTimeout creates a new QueryRulesParams object
// with the ability to set a timeout on a request.
func NewQueryRulesParamsWithTimeout(timeout time.Duration) *QueryRulesParams {
	return &QueryRulesParams{
		timeout: timeout,
	}
}

// NewQueryRulesParamsWithContext creates a new QueryRulesParams object
// with the ability to set a context for a request.
func NewQueryRulesParamsWithContext(ctx context.Context) *QueryRulesParams {
	return &QueryRulesParams{
		Context: ctx,
	}
}

// NewQueryRulesParamsWithHTTPClient creates a new QueryRulesParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryRulesParamsWithHTTPClient(client *http.Client) *QueryRulesParams {
	return &QueryRulesParams{
		HTTPClient: client,
	}
}

/*
QueryRulesParams contains all the parameters to send to the API endpoint

	for the query rules operation.

	Typically these are written to a http.Request.
*/
type QueryRulesParams struct {

	/* Filter.

	   FQL query specifying the filter parameters. Special value '*' means to not filter on anything.
	*/
	Filter *string

	/* Limit.

	   Number of ids to return.
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return ids.
	*/
	Offset *string

	/* Q.

	   Match phrase_prefix query criteria; included fields: _all (all filter string fields indexed).
	*/
	Q *string

	/* Sort.

	   Possible order by fields: name, value, rule_type, customer_id, created_date, updated_date. Ex: 'updated_date|asc'.
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query rules params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryRulesParams) WithDefaults() *QueryRulesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query rules params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryRulesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query rules params
func (o *QueryRulesParams) WithTimeout(timeout time.Duration) *QueryRulesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query rules params
func (o *QueryRulesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query rules params
func (o *QueryRulesParams) WithContext(ctx context.Context) *QueryRulesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query rules params
func (o *QueryRulesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query rules params
func (o *QueryRulesParams) WithHTTPClient(client *http.Client) *QueryRulesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query rules params
func (o *QueryRulesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query rules params
func (o *QueryRulesParams) WithFilter(filter *string) *QueryRulesParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query rules params
func (o *QueryRulesParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query rules params
func (o *QueryRulesParams) WithLimit(limit *int64) *QueryRulesParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query rules params
func (o *QueryRulesParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query rules params
func (o *QueryRulesParams) WithOffset(offset *string) *QueryRulesParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query rules params
func (o *QueryRulesParams) SetOffset(offset *string) {
	o.Offset = offset
}

// WithQ adds the q to the query rules params
func (o *QueryRulesParams) WithQ(q *string) *QueryRulesParams {
	o.SetQ(q)
	return o
}

// SetQ adds the q to the query rules params
func (o *QueryRulesParams) SetQ(q *string) {
	o.Q = q
}

// WithSort adds the sort to the query rules params
func (o *QueryRulesParams) WithSort(sort *string) *QueryRulesParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query rules params
func (o *QueryRulesParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryRulesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Q != nil {

		// query param q
		var qrQ string

		if o.Q != nil {
			qrQ = *o.Q
		}
		qQ := qrQ
		if qQ != "" {

			if err := r.SetQueryParam("q", qQ); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
