// Code generated by go-swagger; DO NOT EDIT.

package tailored_intelligence

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new tailored intelligence API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for tailored intelligence API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	GetEventsBody(params *GetEventsBodyParams, opts ...ClientOption) (*GetEventsBodyOK, error)

	GetEventsEntities(params *GetEventsEntitiesParams, opts ...ClientOption) (*GetEventsEntitiesOK, error)

	GetRulesEntities(params *GetRulesEntitiesParams, opts ...ClientOption) (*GetRulesEntitiesOK, error)

	QueryEvents(params *QueryEventsParams, opts ...ClientOption) (*QueryEventsOK, error)

	QueryRules(params *QueryRulesParams, opts ...ClientOption) (*QueryRulesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
GetEventsBody gets event body for the provided event ID
*/
func (a *Client) GetEventsBody(params *GetEventsBodyParams, opts ...ClientOption) (*GetEventsBodyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetEventsBodyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetEventsBody",
		Method:             "GET",
		PathPattern:        "/ti/events/entities/events-full-body/v2",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetEventsBodyReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetEventsBodyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetEventsBody: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetEventsEntities gets events entities for specified ids
*/
func (a *Client) GetEventsEntities(params *GetEventsEntitiesParams, opts ...ClientOption) (*GetEventsEntitiesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetEventsEntitiesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetEventsEntities",
		Method:             "POST",
		PathPattern:        "/ti/events/entities/events/GET/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetEventsEntitiesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetEventsEntitiesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetEventsEntities: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetRulesEntities gets rules entities for specified ids
*/
func (a *Client) GetRulesEntities(params *GetRulesEntitiesParams, opts ...ClientOption) (*GetRulesEntitiesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRulesEntitiesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetRulesEntities",
		Method:             "POST",
		PathPattern:        "/ti/rules/entities/rules/GET/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetRulesEntitiesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRulesEntitiesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetRulesEntities: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryEvents gets events ids that match the provided filter criteria
*/
func (a *Client) QueryEvents(params *QueryEventsParams, opts ...ClientOption) (*QueryEventsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryEventsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryEvents",
		Method:             "GET",
		PathPattern:        "/ti/events/queries/events/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryEventsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryEventsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryEvents: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryRules gets rules ids that match the provided filter criteria
*/
func (a *Client) QueryRules(params *QueryRulesParams, opts ...ClientOption) (*QueryRulesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryRulesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryRules",
		Method:             "GET",
		PathPattern:        "/ti/rules/queries/rules/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryRulesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryRulesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryRules: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
