// Code generated by go-swagger; DO NOT EDIT.

package user_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewCreateUserV1Params creates a new CreateUserV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateUserV1Params() *CreateUserV1Params {
	return &CreateUserV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateUserV1ParamsWithTimeout creates a new CreateUserV1Params object
// with the ability to set a timeout on a request.
func NewCreateUserV1ParamsWithTimeout(timeout time.Duration) *CreateUserV1Params {
	return &CreateUserV1Params{
		timeout: timeout,
	}
}

// NewCreateUserV1ParamsWithContext creates a new CreateUserV1Params object
// with the ability to set a context for a request.
func NewCreateUserV1ParamsWithContext(ctx context.Context) *CreateUserV1Params {
	return &CreateUserV1Params{
		Context: ctx,
	}
}

// NewCreateUserV1ParamsWithHTTPClient creates a new CreateUserV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewCreateUserV1ParamsWithHTTPClient(client *http.Client) *CreateUserV1Params {
	return &CreateUserV1Params{
		HTTPClient: client,
	}
}

/*
CreateUserV1Params contains all the parameters to send to the API endpoint

	for the create user v1 operation.

	Typically these are written to a http.Request.
*/
type CreateUserV1Params struct {

	/* Body.

	     Attributes for this user. `uid` (required) is the user's email address, which is their username in Falcon.

	Optional attributes:

	<ul><li>`firstName`</li><li>`lastName`</li><li>`password`</li></ul>

	As a best practice, we recommend omitting `password`. If single sign-on is enabled for your customer account, the `password` attribute is ignored. If single sign-on is not enabled, we send a user activation request to their email address when you create the user with no `password`. The user should use the activation email to set their own password.
	*/
	Body *models.DomainCreateUserRequest

	/* ValidateOnly.

	   Validate of user is allowed, but do not create user.
	*/
	ValidateOnly *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create user v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateUserV1Params) WithDefaults() *CreateUserV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create user v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateUserV1Params) SetDefaults() {
	var (
		validateOnlyDefault = bool(false)
	)

	val := CreateUserV1Params{
		ValidateOnly: &validateOnlyDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the create user v1 params
func (o *CreateUserV1Params) WithTimeout(timeout time.Duration) *CreateUserV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create user v1 params
func (o *CreateUserV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create user v1 params
func (o *CreateUserV1Params) WithContext(ctx context.Context) *CreateUserV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create user v1 params
func (o *CreateUserV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create user v1 params
func (o *CreateUserV1Params) WithHTTPClient(client *http.Client) *CreateUserV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create user v1 params
func (o *CreateUserV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create user v1 params
func (o *CreateUserV1Params) WithBody(body *models.DomainCreateUserRequest) *CreateUserV1Params {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create user v1 params
func (o *CreateUserV1Params) SetBody(body *models.DomainCreateUserRequest) {
	o.Body = body
}

// WithValidateOnly adds the validateOnly to the create user v1 params
func (o *CreateUserV1Params) WithValidateOnly(validateOnly *bool) *CreateUserV1Params {
	o.SetValidateOnly(validateOnly)
	return o
}

// SetValidateOnly adds the validateOnly to the create user v1 params
func (o *CreateUserV1Params) SetValidateOnly(validateOnly *bool) {
	o.ValidateOnly = validateOnly
}

// WriteToRequest writes these params to a swagger request
func (o *CreateUserV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.ValidateOnly != nil {

		// query param validate_only
		var qrValidateOnly bool

		if o.ValidateOnly != nil {
			qrValidateOnly = *o.ValidateOnly
		}
		qValidateOnly := swag.FormatBool(qrValidateOnly)
		if qValidateOnly != "" {

			if err := r.SetQueryParam("validate_only", qValidateOnly); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
