// Code generated by go-swagger; DO NOT EDIT.

package user_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetUserRoleIdsParams creates a new GetUserRoleIdsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetUserRoleIdsParams() *GetUserRoleIdsParams {
	return &GetUserRoleIdsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetUserRoleIdsParamsWithTimeout creates a new GetUserRoleIdsParams object
// with the ability to set a timeout on a request.
func NewGetUserRoleIdsParamsWithTimeout(timeout time.Duration) *GetUserRoleIdsParams {
	return &GetUserRoleIdsParams{
		timeout: timeout,
	}
}

// NewGetUserRoleIdsParamsWithContext creates a new GetUserRoleIdsParams object
// with the ability to set a context for a request.
func NewGetUserRoleIdsParamsWithContext(ctx context.Context) *GetUserRoleIdsParams {
	return &GetUserRoleIdsParams{
		Context: ctx,
	}
}

// NewGetUserRoleIdsParamsWithHTTPClient creates a new GetUserRoleIdsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetUserRoleIdsParamsWithHTTPClient(client *http.Client) *GetUserRoleIdsParams {
	return &GetUserRoleIdsParams{
		HTTPClient: client,
	}
}

/*
GetUserRoleIdsParams contains all the parameters to send to the API endpoint

	for the get user role ids operation.

	Typically these are written to a http.Request.
*/
type GetUserRoleIdsParams struct {

	/* UserUUID.

	   ID of a user. Find a user's ID from `/users/entities/user/v1`.
	*/
	UserUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get user role ids params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetUserRoleIdsParams) WithDefaults() *GetUserRoleIdsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get user role ids params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetUserRoleIdsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get user role ids params
func (o *GetUserRoleIdsParams) WithTimeout(timeout time.Duration) *GetUserRoleIdsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get user role ids params
func (o *GetUserRoleIdsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get user role ids params
func (o *GetUserRoleIdsParams) WithContext(ctx context.Context) *GetUserRoleIdsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get user role ids params
func (o *GetUserRoleIdsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get user role ids params
func (o *GetUserRoleIdsParams) WithHTTPClient(client *http.Client) *GetUserRoleIdsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get user role ids params
func (o *GetUserRoleIdsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithUserUUID adds the userUUID to the get user role ids params
func (o *GetUserRoleIdsParams) WithUserUUID(userUUID string) *GetUserRoleIdsParams {
	o.SetUserUUID(userUUID)
	return o
}

// SetUserUUID adds the userUuid to the get user role ids params
func (o *GetUserRoleIdsParams) SetUserUUID(userUUID string) {
	o.UserUUID = userUUID
}

// WriteToRequest writes these params to a swagger request
func (o *GetUserRoleIdsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param user_uuid
	qrUserUUID := o.UserUUID
	qUserUUID := qrUserUUID
	if qUserUUID != "" {

		if err := r.SetQueryParam("user_uuid", qUserUUID); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
