// Code generated by go-swagger; DO NOT EDIT.

package user_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewQueriesRolesV1Params creates a new QueriesRolesV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueriesRolesV1Params() *QueriesRolesV1Params {
	return &QueriesRolesV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueriesRolesV1ParamsWithTimeout creates a new QueriesRolesV1Params object
// with the ability to set a timeout on a request.
func NewQueriesRolesV1ParamsWithTimeout(timeout time.Duration) *QueriesRolesV1Params {
	return &QueriesRolesV1Params{
		timeout: timeout,
	}
}

// NewQueriesRolesV1ParamsWithContext creates a new QueriesRolesV1Params object
// with the ability to set a context for a request.
func NewQueriesRolesV1ParamsWithContext(ctx context.Context) *QueriesRolesV1Params {
	return &QueriesRolesV1Params{
		Context: ctx,
	}
}

// NewQueriesRolesV1ParamsWithHTTPClient creates a new QueriesRolesV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewQueriesRolesV1ParamsWithHTTPClient(client *http.Client) *QueriesRolesV1Params {
	return &QueriesRolesV1Params{
		HTTPClient: client,
	}
}

/*
QueriesRolesV1Params contains all the parameters to send to the API endpoint

	for the queries roles v1 operation.

	Typically these are written to a http.Request.
*/
type QueriesRolesV1Params struct {

	/* Action.

	   Actionable purpose of the query

	   Default: "grant"
	*/
	Action *string

	/* Cid.

	   Customer ID to get available roles for. Empty CID would result in Role IDs for current CID in view.
	*/
	Cid *string

	/* UserUUID.

	   User UUID to get available roles for. Empty User UUID would returns all roles IDs available for customer.
	*/
	UserUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the queries roles v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueriesRolesV1Params) WithDefaults() *QueriesRolesV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the queries roles v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueriesRolesV1Params) SetDefaults() {
	var (
		actionDefault = string("grant")
	)

	val := QueriesRolesV1Params{
		Action: &actionDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the queries roles v1 params
func (o *QueriesRolesV1Params) WithTimeout(timeout time.Duration) *QueriesRolesV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the queries roles v1 params
func (o *QueriesRolesV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the queries roles v1 params
func (o *QueriesRolesV1Params) WithContext(ctx context.Context) *QueriesRolesV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the queries roles v1 params
func (o *QueriesRolesV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the queries roles v1 params
func (o *QueriesRolesV1Params) WithHTTPClient(client *http.Client) *QueriesRolesV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the queries roles v1 params
func (o *QueriesRolesV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAction adds the action to the queries roles v1 params
func (o *QueriesRolesV1Params) WithAction(action *string) *QueriesRolesV1Params {
	o.SetAction(action)
	return o
}

// SetAction adds the action to the queries roles v1 params
func (o *QueriesRolesV1Params) SetAction(action *string) {
	o.Action = action
}

// WithCid adds the cid to the queries roles v1 params
func (o *QueriesRolesV1Params) WithCid(cid *string) *QueriesRolesV1Params {
	o.SetCid(cid)
	return o
}

// SetCid adds the cid to the queries roles v1 params
func (o *QueriesRolesV1Params) SetCid(cid *string) {
	o.Cid = cid
}

// WithUserUUID adds the userUUID to the queries roles v1 params
func (o *QueriesRolesV1Params) WithUserUUID(userUUID *string) *QueriesRolesV1Params {
	o.SetUserUUID(userUUID)
	return o
}

// SetUserUUID adds the userUuid to the queries roles v1 params
func (o *QueriesRolesV1Params) SetUserUUID(userUUID *string) {
	o.UserUUID = userUUID
}

// WriteToRequest writes these params to a swagger request
func (o *QueriesRolesV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Action != nil {

		// query param action
		var qrAction string

		if o.Action != nil {
			qrAction = *o.Action
		}
		qAction := qrAction
		if qAction != "" {

			if err := r.SetQueryParam("action", qAction); err != nil {
				return err
			}
		}
	}

	if o.Cid != nil {

		// query param cid
		var qrCid string

		if o.Cid != nil {
			qrCid = *o.Cid
		}
		qCid := qrCid
		if qCid != "" {

			if err := r.SetQueryParam("cid", qCid); err != nil {
				return err
			}
		}
	}

	if o.UserUUID != nil {

		// query param user_uuid
		var qrUserUUID string

		if o.UserUUID != nil {
			qrUserUUID = *o.UserUUID
		}
		qUserUUID := qrUserUUID
		if qUserUUID != "" {

			if err := r.SetQueryParam("user_uuid", qUserUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
