// Code generated by go-swagger; DO NOT EDIT.

package user_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// RetrieveEmailsByCIDReader is a Reader for the RetrieveEmailsByCID structure.
type RetrieveEmailsByCIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RetrieveEmailsByCIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRetrieveEmailsByCIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRetrieveEmailsByCIDBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRetrieveEmailsByCIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewRetrieveEmailsByCIDTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /users/queries/emails-by-cid/v1] RetrieveEmailsByCID", response, response.Code())
	}
}

// NewRetrieveEmailsByCIDOK creates a RetrieveEmailsByCIDOK with default headers values
func NewRetrieveEmailsByCIDOK() *RetrieveEmailsByCIDOK {
	return &RetrieveEmailsByCIDOK{}
}

/*
RetrieveEmailsByCIDOK describes a response with status code 200, with default header values.

OK
*/
type RetrieveEmailsByCIDOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this retrieve emails by c Id o k response has a 2xx status code
func (o *RetrieveEmailsByCIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this retrieve emails by c Id o k response has a 3xx status code
func (o *RetrieveEmailsByCIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this retrieve emails by c Id o k response has a 4xx status code
func (o *RetrieveEmailsByCIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this retrieve emails by c Id o k response has a 5xx status code
func (o *RetrieveEmailsByCIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this retrieve emails by c Id o k response a status code equal to that given
func (o *RetrieveEmailsByCIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the retrieve emails by c Id o k response
func (o *RetrieveEmailsByCIDOK) Code() int {
	return 200
}

func (o *RetrieveEmailsByCIDOK) Error() string {
	return fmt.Sprintf("[GET /users/queries/emails-by-cid/v1][%d] retrieveEmailsByCIdOK  %+v", 200, o.Payload)
}

func (o *RetrieveEmailsByCIDOK) String() string {
	return fmt.Sprintf("[GET /users/queries/emails-by-cid/v1][%d] retrieveEmailsByCIdOK  %+v", 200, o.Payload)
}

func (o *RetrieveEmailsByCIDOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *RetrieveEmailsByCIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRetrieveEmailsByCIDBadRequest creates a RetrieveEmailsByCIDBadRequest with default headers values
func NewRetrieveEmailsByCIDBadRequest() *RetrieveEmailsByCIDBadRequest {
	return &RetrieveEmailsByCIDBadRequest{}
}

/*
RetrieveEmailsByCIDBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type RetrieveEmailsByCIDBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this retrieve emails by c Id bad request response has a 2xx status code
func (o *RetrieveEmailsByCIDBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this retrieve emails by c Id bad request response has a 3xx status code
func (o *RetrieveEmailsByCIDBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this retrieve emails by c Id bad request response has a 4xx status code
func (o *RetrieveEmailsByCIDBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this retrieve emails by c Id bad request response has a 5xx status code
func (o *RetrieveEmailsByCIDBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this retrieve emails by c Id bad request response a status code equal to that given
func (o *RetrieveEmailsByCIDBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the retrieve emails by c Id bad request response
func (o *RetrieveEmailsByCIDBadRequest) Code() int {
	return 400
}

func (o *RetrieveEmailsByCIDBadRequest) Error() string {
	return fmt.Sprintf("[GET /users/queries/emails-by-cid/v1][%d] retrieveEmailsByCIdBadRequest  %+v", 400, o.Payload)
}

func (o *RetrieveEmailsByCIDBadRequest) String() string {
	return fmt.Sprintf("[GET /users/queries/emails-by-cid/v1][%d] retrieveEmailsByCIdBadRequest  %+v", 400, o.Payload)
}

func (o *RetrieveEmailsByCIDBadRequest) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *RetrieveEmailsByCIDBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRetrieveEmailsByCIDForbidden creates a RetrieveEmailsByCIDForbidden with default headers values
func NewRetrieveEmailsByCIDForbidden() *RetrieveEmailsByCIDForbidden {
	return &RetrieveEmailsByCIDForbidden{}
}

/*
RetrieveEmailsByCIDForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RetrieveEmailsByCIDForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this retrieve emails by c Id forbidden response has a 2xx status code
func (o *RetrieveEmailsByCIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this retrieve emails by c Id forbidden response has a 3xx status code
func (o *RetrieveEmailsByCIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this retrieve emails by c Id forbidden response has a 4xx status code
func (o *RetrieveEmailsByCIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this retrieve emails by c Id forbidden response has a 5xx status code
func (o *RetrieveEmailsByCIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this retrieve emails by c Id forbidden response a status code equal to that given
func (o *RetrieveEmailsByCIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the retrieve emails by c Id forbidden response
func (o *RetrieveEmailsByCIDForbidden) Code() int {
	return 403
}

func (o *RetrieveEmailsByCIDForbidden) Error() string {
	return fmt.Sprintf("[GET /users/queries/emails-by-cid/v1][%d] retrieveEmailsByCIdForbidden  %+v", 403, o.Payload)
}

func (o *RetrieveEmailsByCIDForbidden) String() string {
	return fmt.Sprintf("[GET /users/queries/emails-by-cid/v1][%d] retrieveEmailsByCIdForbidden  %+v", 403, o.Payload)
}

func (o *RetrieveEmailsByCIDForbidden) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *RetrieveEmailsByCIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRetrieveEmailsByCIDTooManyRequests creates a RetrieveEmailsByCIDTooManyRequests with default headers values
func NewRetrieveEmailsByCIDTooManyRequests() *RetrieveEmailsByCIDTooManyRequests {
	return &RetrieveEmailsByCIDTooManyRequests{}
}

/*
RetrieveEmailsByCIDTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type RetrieveEmailsByCIDTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this retrieve emails by c Id too many requests response has a 2xx status code
func (o *RetrieveEmailsByCIDTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this retrieve emails by c Id too many requests response has a 3xx status code
func (o *RetrieveEmailsByCIDTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this retrieve emails by c Id too many requests response has a 4xx status code
func (o *RetrieveEmailsByCIDTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this retrieve emails by c Id too many requests response has a 5xx status code
func (o *RetrieveEmailsByCIDTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this retrieve emails by c Id too many requests response a status code equal to that given
func (o *RetrieveEmailsByCIDTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the retrieve emails by c Id too many requests response
func (o *RetrieveEmailsByCIDTooManyRequests) Code() int {
	return 429
}

func (o *RetrieveEmailsByCIDTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /users/queries/emails-by-cid/v1][%d] retrieveEmailsByCIdTooManyRequests  %+v", 429, o.Payload)
}

func (o *RetrieveEmailsByCIDTooManyRequests) String() string {
	return fmt.Sprintf("[GET /users/queries/emails-by-cid/v1][%d] retrieveEmailsByCIdTooManyRequests  %+v", 429, o.Payload)
}

func (o *RetrieveEmailsByCIDTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RetrieveEmailsByCIDTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
