// Code generated by go-swagger; DO NOT EDIT.

package user_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewRetrieveUserUUIDParams creates a new RetrieveUserUUIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRetrieveUserUUIDParams() *RetrieveUserUUIDParams {
	return &RetrieveUserUUIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRetrieveUserUUIDParamsWithTimeout creates a new RetrieveUserUUIDParams object
// with the ability to set a timeout on a request.
func NewRetrieveUserUUIDParamsWithTimeout(timeout time.Duration) *RetrieveUserUUIDParams {
	return &RetrieveUserUUIDParams{
		timeout: timeout,
	}
}

// NewRetrieveUserUUIDParamsWithContext creates a new RetrieveUserUUIDParams object
// with the ability to set a context for a request.
func NewRetrieveUserUUIDParamsWithContext(ctx context.Context) *RetrieveUserUUIDParams {
	return &RetrieveUserUUIDParams{
		Context: ctx,
	}
}

// NewRetrieveUserUUIDParamsWithHTTPClient creates a new RetrieveUserUUIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewRetrieveUserUUIDParamsWithHTTPClient(client *http.Client) *RetrieveUserUUIDParams {
	return &RetrieveUserUUIDParams{
		HTTPClient: client,
	}
}

/*
RetrieveUserUUIDParams contains all the parameters to send to the API endpoint

	for the retrieve user UUID operation.

	Typically these are written to a http.Request.
*/
type RetrieveUserUUIDParams struct {

	/* UID.

	   A username. This is usually the user's email address, but may vary based on your configuration.
	*/
	UID []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the retrieve user UUID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RetrieveUserUUIDParams) WithDefaults() *RetrieveUserUUIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the retrieve user UUID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RetrieveUserUUIDParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the retrieve user UUID params
func (o *RetrieveUserUUIDParams) WithTimeout(timeout time.Duration) *RetrieveUserUUIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the retrieve user UUID params
func (o *RetrieveUserUUIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the retrieve user UUID params
func (o *RetrieveUserUUIDParams) WithContext(ctx context.Context) *RetrieveUserUUIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the retrieve user UUID params
func (o *RetrieveUserUUIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the retrieve user UUID params
func (o *RetrieveUserUUIDParams) WithHTTPClient(client *http.Client) *RetrieveUserUUIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the retrieve user UUID params
func (o *RetrieveUserUUIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithUID adds the uid to the retrieve user UUID params
func (o *RetrieveUserUUIDParams) WithUID(uid []string) *RetrieveUserUUIDParams {
	o.SetUID(uid)
	return o
}

// SetUID adds the uid to the retrieve user UUID params
func (o *RetrieveUserUUIDParams) SetUID(uid []string) {
	o.UID = uid
}

// WriteToRequest writes these params to a swagger request
func (o *RetrieveUserUUIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.UID != nil {

		// binding items for uid
		joinedUID := o.bindParamUID(reg)

		// query array param uid
		if err := r.SetQueryParam("uid", joinedUID...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamRetrieveUserUUID binds the parameter uid
func (o *RetrieveUserUUIDParams) bindParamUID(formats strfmt.Registry) []string {
	uIDIR := o.UID

	var uIDIC []string
	for _, uIDIIR := range uIDIR { // explode []string

		uIDIIV := uIDIIR // string as string
		uIDIC = append(uIDIC, uIDIIV)
	}

	// items.CollectionFormat: "multi"
	uIDIS := swag.JoinByFormat(uIDIC, "multi")

	return uIDIS
}
