// Code generated by go-swagger; DO NOT EDIT.

package user_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// RetrieveUserUUIDReader is a Reader for the RetrieveUserUUID structure.
type RetrieveUserUUIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RetrieveUserUUIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRetrieveUserUUIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRetrieveUserUUIDBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRetrieveUserUUIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewRetrieveUserUUIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewRetrieveUserUUIDTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /users/queries/user-uuids-by-email/v1] RetrieveUserUUID", response, response.Code())
	}
}

// NewRetrieveUserUUIDOK creates a RetrieveUserUUIDOK with default headers values
func NewRetrieveUserUUIDOK() *RetrieveUserUUIDOK {
	return &RetrieveUserUUIDOK{}
}

/*
RetrieveUserUUIDOK describes a response with status code 200, with default header values.

OK
*/
type RetrieveUserUUIDOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this retrieve user Uuid o k response has a 2xx status code
func (o *RetrieveUserUUIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this retrieve user Uuid o k response has a 3xx status code
func (o *RetrieveUserUUIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this retrieve user Uuid o k response has a 4xx status code
func (o *RetrieveUserUUIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this retrieve user Uuid o k response has a 5xx status code
func (o *RetrieveUserUUIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this retrieve user Uuid o k response a status code equal to that given
func (o *RetrieveUserUUIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the retrieve user Uuid o k response
func (o *RetrieveUserUUIDOK) Code() int {
	return 200
}

func (o *RetrieveUserUUIDOK) Error() string {
	return fmt.Sprintf("[GET /users/queries/user-uuids-by-email/v1][%d] retrieveUserUuidOK  %+v", 200, o.Payload)
}

func (o *RetrieveUserUUIDOK) String() string {
	return fmt.Sprintf("[GET /users/queries/user-uuids-by-email/v1][%d] retrieveUserUuidOK  %+v", 200, o.Payload)
}

func (o *RetrieveUserUUIDOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *RetrieveUserUUIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRetrieveUserUUIDBadRequest creates a RetrieveUserUUIDBadRequest with default headers values
func NewRetrieveUserUUIDBadRequest() *RetrieveUserUUIDBadRequest {
	return &RetrieveUserUUIDBadRequest{}
}

/*
RetrieveUserUUIDBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type RetrieveUserUUIDBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this retrieve user Uuid bad request response has a 2xx status code
func (o *RetrieveUserUUIDBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this retrieve user Uuid bad request response has a 3xx status code
func (o *RetrieveUserUUIDBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this retrieve user Uuid bad request response has a 4xx status code
func (o *RetrieveUserUUIDBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this retrieve user Uuid bad request response has a 5xx status code
func (o *RetrieveUserUUIDBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this retrieve user Uuid bad request response a status code equal to that given
func (o *RetrieveUserUUIDBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the retrieve user Uuid bad request response
func (o *RetrieveUserUUIDBadRequest) Code() int {
	return 400
}

func (o *RetrieveUserUUIDBadRequest) Error() string {
	return fmt.Sprintf("[GET /users/queries/user-uuids-by-email/v1][%d] retrieveUserUuidBadRequest  %+v", 400, o.Payload)
}

func (o *RetrieveUserUUIDBadRequest) String() string {
	return fmt.Sprintf("[GET /users/queries/user-uuids-by-email/v1][%d] retrieveUserUuidBadRequest  %+v", 400, o.Payload)
}

func (o *RetrieveUserUUIDBadRequest) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *RetrieveUserUUIDBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRetrieveUserUUIDForbidden creates a RetrieveUserUUIDForbidden with default headers values
func NewRetrieveUserUUIDForbidden() *RetrieveUserUUIDForbidden {
	return &RetrieveUserUUIDForbidden{}
}

/*
RetrieveUserUUIDForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RetrieveUserUUIDForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this retrieve user Uuid forbidden response has a 2xx status code
func (o *RetrieveUserUUIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this retrieve user Uuid forbidden response has a 3xx status code
func (o *RetrieveUserUUIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this retrieve user Uuid forbidden response has a 4xx status code
func (o *RetrieveUserUUIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this retrieve user Uuid forbidden response has a 5xx status code
func (o *RetrieveUserUUIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this retrieve user Uuid forbidden response a status code equal to that given
func (o *RetrieveUserUUIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the retrieve user Uuid forbidden response
func (o *RetrieveUserUUIDForbidden) Code() int {
	return 403
}

func (o *RetrieveUserUUIDForbidden) Error() string {
	return fmt.Sprintf("[GET /users/queries/user-uuids-by-email/v1][%d] retrieveUserUuidForbidden  %+v", 403, o.Payload)
}

func (o *RetrieveUserUUIDForbidden) String() string {
	return fmt.Sprintf("[GET /users/queries/user-uuids-by-email/v1][%d] retrieveUserUuidForbidden  %+v", 403, o.Payload)
}

func (o *RetrieveUserUUIDForbidden) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *RetrieveUserUUIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRetrieveUserUUIDNotFound creates a RetrieveUserUUIDNotFound with default headers values
func NewRetrieveUserUUIDNotFound() *RetrieveUserUUIDNotFound {
	return &RetrieveUserUUIDNotFound{}
}

/*
RetrieveUserUUIDNotFound describes a response with status code 404, with default header values.

Not Found
*/
type RetrieveUserUUIDNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this retrieve user Uuid not found response has a 2xx status code
func (o *RetrieveUserUUIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this retrieve user Uuid not found response has a 3xx status code
func (o *RetrieveUserUUIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this retrieve user Uuid not found response has a 4xx status code
func (o *RetrieveUserUUIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this retrieve user Uuid not found response has a 5xx status code
func (o *RetrieveUserUUIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this retrieve user Uuid not found response a status code equal to that given
func (o *RetrieveUserUUIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the retrieve user Uuid not found response
func (o *RetrieveUserUUIDNotFound) Code() int {
	return 404
}

func (o *RetrieveUserUUIDNotFound) Error() string {
	return fmt.Sprintf("[GET /users/queries/user-uuids-by-email/v1][%d] retrieveUserUuidNotFound  %+v", 404, o.Payload)
}

func (o *RetrieveUserUUIDNotFound) String() string {
	return fmt.Sprintf("[GET /users/queries/user-uuids-by-email/v1][%d] retrieveUserUuidNotFound  %+v", 404, o.Payload)
}

func (o *RetrieveUserUUIDNotFound) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *RetrieveUserUUIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRetrieveUserUUIDTooManyRequests creates a RetrieveUserUUIDTooManyRequests with default headers values
func NewRetrieveUserUUIDTooManyRequests() *RetrieveUserUUIDTooManyRequests {
	return &RetrieveUserUUIDTooManyRequests{}
}

/*
RetrieveUserUUIDTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type RetrieveUserUUIDTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this retrieve user Uuid too many requests response has a 2xx status code
func (o *RetrieveUserUUIDTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this retrieve user Uuid too many requests response has a 3xx status code
func (o *RetrieveUserUUIDTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this retrieve user Uuid too many requests response has a 4xx status code
func (o *RetrieveUserUUIDTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this retrieve user Uuid too many requests response has a 5xx status code
func (o *RetrieveUserUUIDTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this retrieve user Uuid too many requests response a status code equal to that given
func (o *RetrieveUserUUIDTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the retrieve user Uuid too many requests response
func (o *RetrieveUserUUIDTooManyRequests) Code() int {
	return 429
}

func (o *RetrieveUserUUIDTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /users/queries/user-uuids-by-email/v1][%d] retrieveUserUuidTooManyRequests  %+v", 429, o.Payload)
}

func (o *RetrieveUserUUIDTooManyRequests) String() string {
	return fmt.Sprintf("[GET /users/queries/user-uuids-by-email/v1][%d] retrieveUserUuidTooManyRequests  %+v", 429, o.Payload)
}

func (o *RetrieveUserUUIDTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RetrieveUserUUIDTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
