// Code generated by go-swagger; DO NOT EDIT.

package user_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewRevokeUserRoleIdsParams creates a new RevokeUserRoleIdsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRevokeUserRoleIdsParams() *RevokeUserRoleIdsParams {
	return &RevokeUserRoleIdsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRevokeUserRoleIdsParamsWithTimeout creates a new RevokeUserRoleIdsParams object
// with the ability to set a timeout on a request.
func NewRevokeUserRoleIdsParamsWithTimeout(timeout time.Duration) *RevokeUserRoleIdsParams {
	return &RevokeUserRoleIdsParams{
		timeout: timeout,
	}
}

// NewRevokeUserRoleIdsParamsWithContext creates a new RevokeUserRoleIdsParams object
// with the ability to set a context for a request.
func NewRevokeUserRoleIdsParamsWithContext(ctx context.Context) *RevokeUserRoleIdsParams {
	return &RevokeUserRoleIdsParams{
		Context: ctx,
	}
}

// NewRevokeUserRoleIdsParamsWithHTTPClient creates a new RevokeUserRoleIdsParams object
// with the ability to set a custom HTTPClient for a request.
func NewRevokeUserRoleIdsParamsWithHTTPClient(client *http.Client) *RevokeUserRoleIdsParams {
	return &RevokeUserRoleIdsParams{
		HTTPClient: client,
	}
}

/*
RevokeUserRoleIdsParams contains all the parameters to send to the API endpoint

	for the revoke user role ids operation.

	Typically these are written to a http.Request.
*/
type RevokeUserRoleIdsParams struct {

	/* Ids.

	   One or more role IDs to revoke. Find a role's ID from `/users/queries/roles/v1`.
	*/
	Ids []string

	/* UserUUID.

	   ID of a user. Find a user's ID from `/users/entities/user/v1`.
	*/
	UserUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the revoke user role ids params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RevokeUserRoleIdsParams) WithDefaults() *RevokeUserRoleIdsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the revoke user role ids params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RevokeUserRoleIdsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the revoke user role ids params
func (o *RevokeUserRoleIdsParams) WithTimeout(timeout time.Duration) *RevokeUserRoleIdsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the revoke user role ids params
func (o *RevokeUserRoleIdsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the revoke user role ids params
func (o *RevokeUserRoleIdsParams) WithContext(ctx context.Context) *RevokeUserRoleIdsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the revoke user role ids params
func (o *RevokeUserRoleIdsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the revoke user role ids params
func (o *RevokeUserRoleIdsParams) WithHTTPClient(client *http.Client) *RevokeUserRoleIdsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the revoke user role ids params
func (o *RevokeUserRoleIdsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the revoke user role ids params
func (o *RevokeUserRoleIdsParams) WithIds(ids []string) *RevokeUserRoleIdsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the revoke user role ids params
func (o *RevokeUserRoleIdsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WithUserUUID adds the userUUID to the revoke user role ids params
func (o *RevokeUserRoleIdsParams) WithUserUUID(userUUID string) *RevokeUserRoleIdsParams {
	o.SetUserUUID(userUUID)
	return o
}

// SetUserUUID adds the userUuid to the revoke user role ids params
func (o *RevokeUserRoleIdsParams) SetUserUUID(userUUID string) {
	o.UserUUID = userUUID
}

// WriteToRequest writes these params to a swagger request
func (o *RevokeUserRoleIdsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	// query param user_uuid
	qrUserUUID := o.UserUUID
	qUserUUID := qrUserUUID
	if qUserUUID != "" {

		if err := r.SetQueryParam("user_uuid", qUserUUID); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamRevokeUserRoleIds binds the parameter ids
func (o *RevokeUserRoleIdsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
