// Code generated by go-swagger; DO NOT EDIT.

package user_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewUpdateUserV1Params creates a new UpdateUserV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateUserV1Params() *UpdateUserV1Params {
	return &UpdateUserV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateUserV1ParamsWithTimeout creates a new UpdateUserV1Params object
// with the ability to set a timeout on a request.
func NewUpdateUserV1ParamsWithTimeout(timeout time.Duration) *UpdateUserV1Params {
	return &UpdateUserV1Params{
		timeout: timeout,
	}
}

// NewUpdateUserV1ParamsWithContext creates a new UpdateUserV1Params object
// with the ability to set a context for a request.
func NewUpdateUserV1ParamsWithContext(ctx context.Context) *UpdateUserV1Params {
	return &UpdateUserV1Params{
		Context: ctx,
	}
}

// NewUpdateUserV1ParamsWithHTTPClient creates a new UpdateUserV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateUserV1ParamsWithHTTPClient(client *http.Client) *UpdateUserV1Params {
	return &UpdateUserV1Params{
		HTTPClient: client,
	}
}

/*
UpdateUserV1Params contains all the parameters to send to the API endpoint

	for the update user v1 operation.

	Typically these are written to a http.Request.
*/
type UpdateUserV1Params struct {

	/* Body.

	   Both firstName and lastName have to specified.
	*/
	Body *models.DomainUpdateUserRequest

	/* UserUUID.

	   user uuid
	*/
	UserUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update user v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateUserV1Params) WithDefaults() *UpdateUserV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update user v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateUserV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update user v1 params
func (o *UpdateUserV1Params) WithTimeout(timeout time.Duration) *UpdateUserV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update user v1 params
func (o *UpdateUserV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update user v1 params
func (o *UpdateUserV1Params) WithContext(ctx context.Context) *UpdateUserV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update user v1 params
func (o *UpdateUserV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update user v1 params
func (o *UpdateUserV1Params) WithHTTPClient(client *http.Client) *UpdateUserV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update user v1 params
func (o *UpdateUserV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update user v1 params
func (o *UpdateUserV1Params) WithBody(body *models.DomainUpdateUserRequest) *UpdateUserV1Params {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update user v1 params
func (o *UpdateUserV1Params) SetBody(body *models.DomainUpdateUserRequest) {
	o.Body = body
}

// WithUserUUID adds the userUUID to the update user v1 params
func (o *UpdateUserV1Params) WithUserUUID(userUUID string) *UpdateUserV1Params {
	o.SetUserUUID(userUUID)
	return o
}

// SetUserUUID adds the userUuid to the update user v1 params
func (o *UpdateUserV1Params) SetUserUUID(userUUID string) {
	o.UserUUID = userUUID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateUserV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// query param user_uuid
	qrUserUUID := o.UserUUID
	qUserUUID := qrUserUUID
	if qUserUUID != "" {

		if err := r.SetQueryParam("user_uuid", qUserUUID); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
