// Code generated by go-swagger; DO NOT EDIT.

package user_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewUserActionV1Params creates a new UserActionV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUserActionV1Params() *UserActionV1Params {
	return &UserActionV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewUserActionV1ParamsWithTimeout creates a new UserActionV1Params object
// with the ability to set a timeout on a request.
func NewUserActionV1ParamsWithTimeout(timeout time.Duration) *UserActionV1Params {
	return &UserActionV1Params{
		timeout: timeout,
	}
}

// NewUserActionV1ParamsWithContext creates a new UserActionV1Params object
// with the ability to set a context for a request.
func NewUserActionV1ParamsWithContext(ctx context.Context) *UserActionV1Params {
	return &UserActionV1Params{
		Context: ctx,
	}
}

// NewUserActionV1ParamsWithHTTPClient creates a new UserActionV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewUserActionV1ParamsWithHTTPClient(client *http.Client) *UserActionV1Params {
	return &UserActionV1Params{
		HTTPClient: client,
	}
}

/*
UserActionV1Params contains all the parameters to send to the API endpoint

	for the user action v1 operation.

	Typically these are written to a http.Request.
*/
type UserActionV1Params struct {

	/* Body.

	   User UUIDs and Action Name params are required. Allowed values for Action Name param includes 'reset_2fa' and 'reset_password'
	*/
	Body *models.DomainUserActionRequest

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the user action v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UserActionV1Params) WithDefaults() *UserActionV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the user action v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UserActionV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the user action v1 params
func (o *UserActionV1Params) WithTimeout(timeout time.Duration) *UserActionV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the user action v1 params
func (o *UserActionV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the user action v1 params
func (o *UserActionV1Params) WithContext(ctx context.Context) *UserActionV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the user action v1 params
func (o *UserActionV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the user action v1 params
func (o *UserActionV1Params) WithHTTPClient(client *http.Client) *UserActionV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the user action v1 params
func (o *UserActionV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the user action v1 params
func (o *UserActionV1Params) WithBody(body *models.DomainUserActionRequest) *UserActionV1Params {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the user action v1 params
func (o *UserActionV1Params) SetBody(body *models.DomainUserActionRequest) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *UserActionV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
