// Code generated by go-swagger; DO NOT EDIT.

package vulnerabilities

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetVulnerabilitiesParams creates a new GetVulnerabilitiesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetVulnerabilitiesParams() *GetVulnerabilitiesParams {
	return &GetVulnerabilitiesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetVulnerabilitiesParamsWithTimeout creates a new GetVulnerabilitiesParams object
// with the ability to set a timeout on a request.
func NewGetVulnerabilitiesParamsWithTimeout(timeout time.Duration) *GetVulnerabilitiesParams {
	return &GetVulnerabilitiesParams{
		timeout: timeout,
	}
}

// NewGetVulnerabilitiesParamsWithContext creates a new GetVulnerabilitiesParams object
// with the ability to set a context for a request.
func NewGetVulnerabilitiesParamsWithContext(ctx context.Context) *GetVulnerabilitiesParams {
	return &GetVulnerabilitiesParams{
		Context: ctx,
	}
}

// NewGetVulnerabilitiesParamsWithHTTPClient creates a new GetVulnerabilitiesParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetVulnerabilitiesParamsWithHTTPClient(client *http.Client) *GetVulnerabilitiesParams {
	return &GetVulnerabilitiesParams{
		HTTPClient: client,
	}
}

/*
GetVulnerabilitiesParams contains all the parameters to send to the API endpoint

	for the get vulnerabilities operation.

	Typically these are written to a http.Request.
*/
type GetVulnerabilitiesParams struct {

	/* Ids.

	   One or more vulnerability IDs (max: 400). Find vulnerability IDs with GET /spotlight/queries/vulnerabilities/v1
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get vulnerabilities params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetVulnerabilitiesParams) WithDefaults() *GetVulnerabilitiesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get vulnerabilities params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetVulnerabilitiesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get vulnerabilities params
func (o *GetVulnerabilitiesParams) WithTimeout(timeout time.Duration) *GetVulnerabilitiesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get vulnerabilities params
func (o *GetVulnerabilitiesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get vulnerabilities params
func (o *GetVulnerabilitiesParams) WithContext(ctx context.Context) *GetVulnerabilitiesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get vulnerabilities params
func (o *GetVulnerabilitiesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get vulnerabilities params
func (o *GetVulnerabilitiesParams) WithHTTPClient(client *http.Client) *GetVulnerabilitiesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get vulnerabilities params
func (o *GetVulnerabilitiesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get vulnerabilities params
func (o *GetVulnerabilitiesParams) WithIds(ids []string) *GetVulnerabilitiesParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get vulnerabilities params
func (o *GetVulnerabilitiesParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetVulnerabilitiesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetVulnerabilities binds the parameter ids
func (o *GetVulnerabilitiesParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
