// Code generated by go-swagger; DO NOT EDIT.

package vulnerabilities

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryVulnerabilitiesParams creates a new QueryVulnerabilitiesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryVulnerabilitiesParams() *QueryVulnerabilitiesParams {
	return &QueryVulnerabilitiesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryVulnerabilitiesParamsWithTimeout creates a new QueryVulnerabilitiesParams object
// with the ability to set a timeout on a request.
func NewQueryVulnerabilitiesParamsWithTimeout(timeout time.Duration) *QueryVulnerabilitiesParams {
	return &QueryVulnerabilitiesParams{
		timeout: timeout,
	}
}

// NewQueryVulnerabilitiesParamsWithContext creates a new QueryVulnerabilitiesParams object
// with the ability to set a context for a request.
func NewQueryVulnerabilitiesParamsWithContext(ctx context.Context) *QueryVulnerabilitiesParams {
	return &QueryVulnerabilitiesParams{
		Context: ctx,
	}
}

// NewQueryVulnerabilitiesParamsWithHTTPClient creates a new QueryVulnerabilitiesParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryVulnerabilitiesParamsWithHTTPClient(client *http.Client) *QueryVulnerabilitiesParams {
	return &QueryVulnerabilitiesParams{
		HTTPClient: client,
	}
}

/*
QueryVulnerabilitiesParams contains all the parameters to send to the API endpoint

	for the query vulnerabilities operation.

	Typically these are written to a http.Request.
*/
type QueryVulnerabilitiesParams struct {

	/* After.

	   A pagination token used with the `limit` parameter to manage pagination of results. On your first request, don't provide an `after` token. On subsequent requests, provide the `after` token from the previous response to continue from that place in the results.
	*/
	After *string

	/* Filter.

	     Filter items using a query in Falcon Query Language (FQL). Wildcards * and empty filter values are unsupported.
				Available filter fields that supports match (~): N/A
				Available filter fields that supports exact match: aid, cid, last_seen_within, status, cve.id, cve.is_cisa_kev, cve.remediation_level, cve.cps_rating, cve.exprt_rating, cve.exploit_status_to_include, cve.severity, host_info.asset_criticality, host_info.asset_roles, host_info.internet_exposure, host_info.tags, host_info.groups, host_info.product_type_desc, host_info.platform_name, suppression_info.is_suppressed, suppression_info.reason
				Available filter fields that supports wildcard (*): N/A
				Available filter fields that supports range comparisons (>, <, >=, <=): created_timestamp, closed_timestamp, updated_timestamp

	*/
	Filter string

	/* Limit.

	   The number of items to return in this response (default: 100, max: 400). Use with the after parameter to manage pagination of results.
	*/
	Limit *int64

	/* Sort.

	     Sort vulnerabilities by their properties. Available sort options:

	<ul><li>updated_timestamp|asc/desc</li><li>closed_timestamp|asc</li><li>updated_timestamp|asc/desc</li></ul>. Can be used in a format <field>|asc for ascending order or <field>|desc for descending order.
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query vulnerabilities params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryVulnerabilitiesParams) WithDefaults() *QueryVulnerabilitiesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query vulnerabilities params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryVulnerabilitiesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithTimeout(timeout time.Duration) *QueryVulnerabilitiesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithContext(ctx context.Context) *QueryVulnerabilitiesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithHTTPClient(client *http.Client) *QueryVulnerabilitiesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAfter adds the after to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithAfter(after *string) *QueryVulnerabilitiesParams {
	o.SetAfter(after)
	return o
}

// SetAfter adds the after to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetAfter(after *string) {
	o.After = after
}

// WithFilter adds the filter to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithFilter(filter string) *QueryVulnerabilitiesParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetFilter(filter string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithLimit(limit *int64) *QueryVulnerabilitiesParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithSort adds the sort to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) WithSort(sort *string) *QueryVulnerabilitiesParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query vulnerabilities params
func (o *QueryVulnerabilitiesParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryVulnerabilitiesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.After != nil {

		// query param after
		var qrAfter string

		if o.After != nil {
			qrAfter = *o.After
		}
		qAfter := qrAfter
		if qAfter != "" {

			if err := r.SetQueryParam("after", qAfter); err != nil {
				return err
			}
		}
	}

	// query param filter
	qrFilter := o.Filter
	qFilter := qrFilter
	if qFilter != "" {

		if err := r.SetQueryParam("filter", qFilter); err != nil {
			return err
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
