// Code generated by go-swagger; DO NOT EDIT.

package vulnerabilities_evaluation_logic

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetEvaluationLogicParams creates a new GetEvaluationLogicParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetEvaluationLogicParams() *GetEvaluationLogicParams {
	return &GetEvaluationLogicParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetEvaluationLogicParamsWithTimeout creates a new GetEvaluationLogicParams object
// with the ability to set a timeout on a request.
func NewGetEvaluationLogicParamsWithTimeout(timeout time.Duration) *GetEvaluationLogicParams {
	return &GetEvaluationLogicParams{
		timeout: timeout,
	}
}

// NewGetEvaluationLogicParamsWithContext creates a new GetEvaluationLogicParams object
// with the ability to set a context for a request.
func NewGetEvaluationLogicParamsWithContext(ctx context.Context) *GetEvaluationLogicParams {
	return &GetEvaluationLogicParams{
		Context: ctx,
	}
}

// NewGetEvaluationLogicParamsWithHTTPClient creates a new GetEvaluationLogicParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetEvaluationLogicParamsWithHTTPClient(client *http.Client) *GetEvaluationLogicParams {
	return &GetEvaluationLogicParams{
		HTTPClient: client,
	}
}

/*
GetEvaluationLogicParams contains all the parameters to send to the API endpoint

	for the get evaluation logic operation.

	Typically these are written to a http.Request.
*/
type GetEvaluationLogicParams struct {

	/* Ids.

	   One or more evaluation logic IDs.
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get evaluation logic params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetEvaluationLogicParams) WithDefaults() *GetEvaluationLogicParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get evaluation logic params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetEvaluationLogicParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get evaluation logic params
func (o *GetEvaluationLogicParams) WithTimeout(timeout time.Duration) *GetEvaluationLogicParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get evaluation logic params
func (o *GetEvaluationLogicParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get evaluation logic params
func (o *GetEvaluationLogicParams) WithContext(ctx context.Context) *GetEvaluationLogicParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get evaluation logic params
func (o *GetEvaluationLogicParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get evaluation logic params
func (o *GetEvaluationLogicParams) WithHTTPClient(client *http.Client) *GetEvaluationLogicParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get evaluation logic params
func (o *GetEvaluationLogicParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get evaluation logic params
func (o *GetEvaluationLogicParams) WithIds(ids []string) *GetEvaluationLogicParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get evaluation logic params
func (o *GetEvaluationLogicParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetEvaluationLogicParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetEvaluationLogic binds the parameter ids
func (o *GetEvaluationLogicParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
