// Code generated by go-swagger; DO NOT EDIT.

package vulnerabilities_evaluation_logic

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetEvaluationLogicReader is a Reader for the GetEvaluationLogic structure.
type GetEvaluationLogicReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetEvaluationLogicReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetEvaluationLogicOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetEvaluationLogicBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetEvaluationLogicForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetEvaluationLogicTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetEvaluationLogicInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /spotlight/entities/evaluation-logic/v1] getEvaluationLogic", response, response.Code())
	}
}

// NewGetEvaluationLogicOK creates a GetEvaluationLogicOK with default headers values
func NewGetEvaluationLogicOK() *GetEvaluationLogicOK {
	return &GetEvaluationLogicOK{}
}

/*
GetEvaluationLogicOK describes a response with status code 200, with default header values.

OK
*/
type GetEvaluationLogicOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainSPAPIEvaluationLogicEntitiesResponseV1
}

// IsSuccess returns true when this get evaluation logic o k response has a 2xx status code
func (o *GetEvaluationLogicOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get evaluation logic o k response has a 3xx status code
func (o *GetEvaluationLogicOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get evaluation logic o k response has a 4xx status code
func (o *GetEvaluationLogicOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get evaluation logic o k response has a 5xx status code
func (o *GetEvaluationLogicOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get evaluation logic o k response a status code equal to that given
func (o *GetEvaluationLogicOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get evaluation logic o k response
func (o *GetEvaluationLogicOK) Code() int {
	return 200
}

func (o *GetEvaluationLogicOK) Error() string {
	return fmt.Sprintf("[GET /spotlight/entities/evaluation-logic/v1][%d] getEvaluationLogicOK  %+v", 200, o.Payload)
}

func (o *GetEvaluationLogicOK) String() string {
	return fmt.Sprintf("[GET /spotlight/entities/evaluation-logic/v1][%d] getEvaluationLogicOK  %+v", 200, o.Payload)
}

func (o *GetEvaluationLogicOK) GetPayload() *models.DomainSPAPIEvaluationLogicEntitiesResponseV1 {
	return o.Payload
}

func (o *GetEvaluationLogicOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainSPAPIEvaluationLogicEntitiesResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetEvaluationLogicBadRequest creates a GetEvaluationLogicBadRequest with default headers values
func NewGetEvaluationLogicBadRequest() *GetEvaluationLogicBadRequest {
	return &GetEvaluationLogicBadRequest{}
}

/*
GetEvaluationLogicBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetEvaluationLogicBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64
}

// IsSuccess returns true when this get evaluation logic bad request response has a 2xx status code
func (o *GetEvaluationLogicBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get evaluation logic bad request response has a 3xx status code
func (o *GetEvaluationLogicBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get evaluation logic bad request response has a 4xx status code
func (o *GetEvaluationLogicBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get evaluation logic bad request response has a 5xx status code
func (o *GetEvaluationLogicBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get evaluation logic bad request response a status code equal to that given
func (o *GetEvaluationLogicBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get evaluation logic bad request response
func (o *GetEvaluationLogicBadRequest) Code() int {
	return 400
}

func (o *GetEvaluationLogicBadRequest) Error() string {
	return fmt.Sprintf("[GET /spotlight/entities/evaluation-logic/v1][%d] getEvaluationLogicBadRequest ", 400)
}

func (o *GetEvaluationLogicBadRequest) String() string {
	return fmt.Sprintf("[GET /spotlight/entities/evaluation-logic/v1][%d] getEvaluationLogicBadRequest ", 400)
}

func (o *GetEvaluationLogicBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	return nil
}

// NewGetEvaluationLogicForbidden creates a GetEvaluationLogicForbidden with default headers values
func NewGetEvaluationLogicForbidden() *GetEvaluationLogicForbidden {
	return &GetEvaluationLogicForbidden{}
}

/*
GetEvaluationLogicForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetEvaluationLogicForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get evaluation logic forbidden response has a 2xx status code
func (o *GetEvaluationLogicForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get evaluation logic forbidden response has a 3xx status code
func (o *GetEvaluationLogicForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get evaluation logic forbidden response has a 4xx status code
func (o *GetEvaluationLogicForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get evaluation logic forbidden response has a 5xx status code
func (o *GetEvaluationLogicForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get evaluation logic forbidden response a status code equal to that given
func (o *GetEvaluationLogicForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get evaluation logic forbidden response
func (o *GetEvaluationLogicForbidden) Code() int {
	return 403
}

func (o *GetEvaluationLogicForbidden) Error() string {
	return fmt.Sprintf("[GET /spotlight/entities/evaluation-logic/v1][%d] getEvaluationLogicForbidden  %+v", 403, o.Payload)
}

func (o *GetEvaluationLogicForbidden) String() string {
	return fmt.Sprintf("[GET /spotlight/entities/evaluation-logic/v1][%d] getEvaluationLogicForbidden  %+v", 403, o.Payload)
}

func (o *GetEvaluationLogicForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetEvaluationLogicForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetEvaluationLogicTooManyRequests creates a GetEvaluationLogicTooManyRequests with default headers values
func NewGetEvaluationLogicTooManyRequests() *GetEvaluationLogicTooManyRequests {
	return &GetEvaluationLogicTooManyRequests{}
}

/*
GetEvaluationLogicTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetEvaluationLogicTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get evaluation logic too many requests response has a 2xx status code
func (o *GetEvaluationLogicTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get evaluation logic too many requests response has a 3xx status code
func (o *GetEvaluationLogicTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get evaluation logic too many requests response has a 4xx status code
func (o *GetEvaluationLogicTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get evaluation logic too many requests response has a 5xx status code
func (o *GetEvaluationLogicTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get evaluation logic too many requests response a status code equal to that given
func (o *GetEvaluationLogicTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get evaluation logic too many requests response
func (o *GetEvaluationLogicTooManyRequests) Code() int {
	return 429
}

func (o *GetEvaluationLogicTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /spotlight/entities/evaluation-logic/v1][%d] getEvaluationLogicTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetEvaluationLogicTooManyRequests) String() string {
	return fmt.Sprintf("[GET /spotlight/entities/evaluation-logic/v1][%d] getEvaluationLogicTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetEvaluationLogicTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetEvaluationLogicTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetEvaluationLogicInternalServerError creates a GetEvaluationLogicInternalServerError with default headers values
func NewGetEvaluationLogicInternalServerError() *GetEvaluationLogicInternalServerError {
	return &GetEvaluationLogicInternalServerError{}
}

/*
GetEvaluationLogicInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetEvaluationLogicInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64
}

// IsSuccess returns true when this get evaluation logic internal server error response has a 2xx status code
func (o *GetEvaluationLogicInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get evaluation logic internal server error response has a 3xx status code
func (o *GetEvaluationLogicInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get evaluation logic internal server error response has a 4xx status code
func (o *GetEvaluationLogicInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get evaluation logic internal server error response has a 5xx status code
func (o *GetEvaluationLogicInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get evaluation logic internal server error response a status code equal to that given
func (o *GetEvaluationLogicInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get evaluation logic internal server error response
func (o *GetEvaluationLogicInternalServerError) Code() int {
	return 500
}

func (o *GetEvaluationLogicInternalServerError) Error() string {
	return fmt.Sprintf("[GET /spotlight/entities/evaluation-logic/v1][%d] getEvaluationLogicInternalServerError ", 500)
}

func (o *GetEvaluationLogicInternalServerError) String() string {
	return fmt.Sprintf("[GET /spotlight/entities/evaluation-logic/v1][%d] getEvaluationLogicInternalServerError ", 500)
}

func (o *GetEvaluationLogicInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	return nil
}
