// Code generated by go-swagger; DO NOT EDIT.

package vulnerabilities_evaluation_logic

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new vulnerabilities evaluation logic API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for vulnerabilities evaluation logic API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CombinedQueryEvaluationLogic(params *CombinedQueryEvaluationLogicParams, opts ...ClientOption) (*CombinedQueryEvaluationLogicOK, error)

	GetEvaluationLogic(params *GetEvaluationLogicParams, opts ...ClientOption) (*GetEvaluationLogicOK, error)

	QueryEvaluationLogic(params *QueryEvaluationLogicParams, opts ...ClientOption) (*QueryEvaluationLogicOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CombinedQueryEvaluationLogic searches for evaluation logic in your environment by providing a f q l filter and paging details returns a set of evaluation logic entities which match the filter criteria
*/
func (a *Client) CombinedQueryEvaluationLogic(params *CombinedQueryEvaluationLogicParams, opts ...ClientOption) (*CombinedQueryEvaluationLogicOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCombinedQueryEvaluationLogicParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "combinedQueryEvaluationLogic",
		Method:             "GET",
		PathPattern:        "/spotlight/combined/evaluation-logic/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CombinedQueryEvaluationLogicReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CombinedQueryEvaluationLogicOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for combinedQueryEvaluationLogic: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetEvaluationLogic gets details on evaluation logic items by providing one or more i ds
*/
func (a *Client) GetEvaluationLogic(params *GetEvaluationLogicParams, opts ...ClientOption) (*GetEvaluationLogicOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetEvaluationLogicParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getEvaluationLogic",
		Method:             "GET",
		PathPattern:        "/spotlight/entities/evaluation-logic/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetEvaluationLogicReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetEvaluationLogicOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getEvaluationLogic: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryEvaluationLogic searches for evaluation logic in your environment by providing a f q l filter and paging details returns a set of evaluation logic i ds which match the filter criteria
*/
func (a *Client) QueryEvaluationLogic(params *QueryEvaluationLogicParams, opts ...ClientOption) (*QueryEvaluationLogicOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryEvaluationLogicParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryEvaluationLogic",
		Method:             "GET",
		PathPattern:        "/spotlight/queries/evaluation-logic/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryEvaluationLogicReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryEvaluationLogicOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryEvaluationLogic: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
