// Code generated by go-swagger; DO NOT EDIT.

package zero_trust_assessment

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetAssessmentsByScoreV1Params creates a new GetAssessmentsByScoreV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAssessmentsByScoreV1Params() *GetAssessmentsByScoreV1Params {
	return &GetAssessmentsByScoreV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAssessmentsByScoreV1ParamsWithTimeout creates a new GetAssessmentsByScoreV1Params object
// with the ability to set a timeout on a request.
func NewGetAssessmentsByScoreV1ParamsWithTimeout(timeout time.Duration) *GetAssessmentsByScoreV1Params {
	return &GetAssessmentsByScoreV1Params{
		timeout: timeout,
	}
}

// NewGetAssessmentsByScoreV1ParamsWithContext creates a new GetAssessmentsByScoreV1Params object
// with the ability to set a context for a request.
func NewGetAssessmentsByScoreV1ParamsWithContext(ctx context.Context) *GetAssessmentsByScoreV1Params {
	return &GetAssessmentsByScoreV1Params{
		Context: ctx,
	}
}

// NewGetAssessmentsByScoreV1ParamsWithHTTPClient creates a new GetAssessmentsByScoreV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewGetAssessmentsByScoreV1ParamsWithHTTPClient(client *http.Client) *GetAssessmentsByScoreV1Params {
	return &GetAssessmentsByScoreV1Params{
		HTTPClient: client,
	}
}

/*
GetAssessmentsByScoreV1Params contains all the parameters to send to the API endpoint

	for the get assessments by score v1 operation.

	Typically these are written to a http.Request.
*/
type GetAssessmentsByScoreV1Params struct {

	/* After.

	   A pagination token used with the `limit` parameter to manage pagination of results. On your first request, don't provide an `after` token. On subsequent requests, provide the `after` token from the previous response to continue from that place in the results.
	*/
	After *string

	/* Filter.

	   FQL query specifying the filter score.
	*/
	Filter string

	/* Limit.

	   The number of scores to return in this response (min: 1, max: 1000, default: 100). Use with the `after` parameter to manage pagination of results.
	*/
	Limit *int64

	/* Sort.

	     Sort accounts by their properties. A single sort field is allowed. Defaults to ascending. Supported sort option include:

	<ul><li>score|desc</li><li>score|asc</li></ul>

	     Default: "score"
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get assessments by score v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAssessmentsByScoreV1Params) WithDefaults() *GetAssessmentsByScoreV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get assessments by score v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAssessmentsByScoreV1Params) SetDefaults() {
	var (
		sortDefault = string("score")
	)

	val := GetAssessmentsByScoreV1Params{
		Sort: &sortDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) WithTimeout(timeout time.Duration) *GetAssessmentsByScoreV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) WithContext(ctx context.Context) *GetAssessmentsByScoreV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) WithHTTPClient(client *http.Client) *GetAssessmentsByScoreV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAfter adds the after to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) WithAfter(after *string) *GetAssessmentsByScoreV1Params {
	o.SetAfter(after)
	return o
}

// SetAfter adds the after to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) SetAfter(after *string) {
	o.After = after
}

// WithFilter adds the filter to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) WithFilter(filter string) *GetAssessmentsByScoreV1Params {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) SetFilter(filter string) {
	o.Filter = filter
}

// WithLimit adds the limit to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) WithLimit(limit *int64) *GetAssessmentsByScoreV1Params {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithSort adds the sort to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) WithSort(sort *string) *GetAssessmentsByScoreV1Params {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the get assessments by score v1 params
func (o *GetAssessmentsByScoreV1Params) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *GetAssessmentsByScoreV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.After != nil {

		// query param after
		var qrAfter string

		if o.After != nil {
			qrAfter = *o.After
		}
		qAfter := qrAfter
		if qAfter != "" {

			if err := r.SetQueryParam("after", qAfter); err != nil {
				return err
			}
		}
	}

	// query param filter
	qrFilter := o.Filter
	qFilter := qrFilter
	if qFilter != "" {

		if err := r.SetQueryParam("filter", qFilter); err != nil {
			return err
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
