// Code generated by go-swagger; DO NOT EDIT.

package zero_trust_assessment

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetAuditV1Reader is a Reader for the GetAuditV1 structure.
type GetAuditV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAuditV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAuditV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetAuditV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetAuditV1NotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetAuditV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /zero-trust-assessment/entities/audit/v1] getAuditV1", response, response.Code())
	}
}

// NewGetAuditV1OK creates a GetAuditV1OK with default headers values
func NewGetAuditV1OK() *GetAuditV1OK {
	return &GetAuditV1OK{}
}

/*
GetAuditV1OK describes a response with status code 200, with default header values.

OK
*/
type GetAuditV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAuditResponse
}

// IsSuccess returns true when this get audit v1 o k response has a 2xx status code
func (o *GetAuditV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get audit v1 o k response has a 3xx status code
func (o *GetAuditV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get audit v1 o k response has a 4xx status code
func (o *GetAuditV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get audit v1 o k response has a 5xx status code
func (o *GetAuditV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this get audit v1 o k response a status code equal to that given
func (o *GetAuditV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get audit v1 o k response
func (o *GetAuditV1OK) Code() int {
	return 200
}

func (o *GetAuditV1OK) Error() string {
	return fmt.Sprintf("[GET /zero-trust-assessment/entities/audit/v1][%d] getAuditV1OK  %+v", 200, o.Payload)
}

func (o *GetAuditV1OK) String() string {
	return fmt.Sprintf("[GET /zero-trust-assessment/entities/audit/v1][%d] getAuditV1OK  %+v", 200, o.Payload)
}

func (o *GetAuditV1OK) GetPayload() *models.DomainAuditResponse {
	return o.Payload
}

func (o *GetAuditV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAuditResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAuditV1Forbidden creates a GetAuditV1Forbidden with default headers values
func NewGetAuditV1Forbidden() *GetAuditV1Forbidden {
	return &GetAuditV1Forbidden{}
}

/*
GetAuditV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetAuditV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get audit v1 forbidden response has a 2xx status code
func (o *GetAuditV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get audit v1 forbidden response has a 3xx status code
func (o *GetAuditV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get audit v1 forbidden response has a 4xx status code
func (o *GetAuditV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get audit v1 forbidden response has a 5xx status code
func (o *GetAuditV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get audit v1 forbidden response a status code equal to that given
func (o *GetAuditV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get audit v1 forbidden response
func (o *GetAuditV1Forbidden) Code() int {
	return 403
}

func (o *GetAuditV1Forbidden) Error() string {
	return fmt.Sprintf("[GET /zero-trust-assessment/entities/audit/v1][%d] getAuditV1Forbidden  %+v", 403, o.Payload)
}

func (o *GetAuditV1Forbidden) String() string {
	return fmt.Sprintf("[GET /zero-trust-assessment/entities/audit/v1][%d] getAuditV1Forbidden  %+v", 403, o.Payload)
}

func (o *GetAuditV1Forbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAuditV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAuditV1NotFound creates a GetAuditV1NotFound with default headers values
func NewGetAuditV1NotFound() *GetAuditV1NotFound {
	return &GetAuditV1NotFound{}
}

/*
GetAuditV1NotFound describes a response with status code 404, with default header values.

One or more of the specified agent IDs is not found.
*/
type GetAuditV1NotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAuditResponse
}

// IsSuccess returns true when this get audit v1 not found response has a 2xx status code
func (o *GetAuditV1NotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get audit v1 not found response has a 3xx status code
func (o *GetAuditV1NotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get audit v1 not found response has a 4xx status code
func (o *GetAuditV1NotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get audit v1 not found response has a 5xx status code
func (o *GetAuditV1NotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get audit v1 not found response a status code equal to that given
func (o *GetAuditV1NotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get audit v1 not found response
func (o *GetAuditV1NotFound) Code() int {
	return 404
}

func (o *GetAuditV1NotFound) Error() string {
	return fmt.Sprintf("[GET /zero-trust-assessment/entities/audit/v1][%d] getAuditV1NotFound  %+v", 404, o.Payload)
}

func (o *GetAuditV1NotFound) String() string {
	return fmt.Sprintf("[GET /zero-trust-assessment/entities/audit/v1][%d] getAuditV1NotFound  %+v", 404, o.Payload)
}

func (o *GetAuditV1NotFound) GetPayload() *models.DomainAuditResponse {
	return o.Payload
}

func (o *GetAuditV1NotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAuditResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAuditV1TooManyRequests creates a GetAuditV1TooManyRequests with default headers values
func NewGetAuditV1TooManyRequests() *GetAuditV1TooManyRequests {
	return &GetAuditV1TooManyRequests{}
}

/*
GetAuditV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetAuditV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get audit v1 too many requests response has a 2xx status code
func (o *GetAuditV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get audit v1 too many requests response has a 3xx status code
func (o *GetAuditV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get audit v1 too many requests response has a 4xx status code
func (o *GetAuditV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get audit v1 too many requests response has a 5xx status code
func (o *GetAuditV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get audit v1 too many requests response a status code equal to that given
func (o *GetAuditV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get audit v1 too many requests response
func (o *GetAuditV1TooManyRequests) Code() int {
	return 429
}

func (o *GetAuditV1TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /zero-trust-assessment/entities/audit/v1][%d] getAuditV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAuditV1TooManyRequests) String() string {
	return fmt.Sprintf("[GET /zero-trust-assessment/entities/audit/v1][%d] getAuditV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAuditV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAuditV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
