// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// APIAuditEventDetailsResourceV1 api audit event details resource v1
//
// swagger:model api.auditEventDetailsResourceV1
type APIAuditEventDetailsResourceV1 struct {

	// action
	// Required: true
	Action *string `json:"action"`

	// actor
	// Required: true
	Actor *string `json:"actor"`

	// description
	// Required: true
	Description *string `json:"description"`

	// id
	// Required: true
	ID *string `json:"id"`

	// timestamp
	// Required: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp"`

	// token id
	// Required: true
	TokenID *string `json:"token_id"`
}

// Validate validates this api audit event details resource v1
func (m *APIAuditEventDetailsResourceV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateActor(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDescription(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTokenID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APIAuditEventDetailsResourceV1) validateAction(formats strfmt.Registry) error {

	if err := validate.Required("action", "body", m.Action); err != nil {
		return err
	}

	return nil
}

func (m *APIAuditEventDetailsResourceV1) validateActor(formats strfmt.Registry) error {

	if err := validate.Required("actor", "body", m.Actor); err != nil {
		return err
	}

	return nil
}

func (m *APIAuditEventDetailsResourceV1) validateDescription(formats strfmt.Registry) error {

	if err := validate.Required("description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *APIAuditEventDetailsResourceV1) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *APIAuditEventDetailsResourceV1) validateTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *APIAuditEventDetailsResourceV1) validateTokenID(formats strfmt.Registry) error {

	if err := validate.Required("token_id", "body", m.TokenID); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this api audit event details resource v1 based on context it is used
func (m *APIAuditEventDetailsResourceV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *APIAuditEventDetailsResourceV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *APIAuditEventDetailsResourceV1) UnmarshalBinary(b []byte) error {
	var res APIAuditEventDetailsResourceV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
