// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// APIImageLookupRequest api image lookup request
//
// swagger:model api.ImageLookupRequest
type APIImageLookupRequest struct {

	// application packages
	ApplicationPackages []*ModelsApplicationPackageInfoType `json:"applicationPackages"`

	// osversion
	// Required: true
	Osversion *string `json:"osversion"`

	// packages
	// Required: true
	Packages []*ModelsPackageInfoType `json:"packages"`
}

// Validate validates this api image lookup request
func (m *APIImageLookupRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateApplicationPackages(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsversion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePackages(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APIImageLookupRequest) validateApplicationPackages(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationPackages) { // not required
		return nil
	}

	for i := 0; i < len(m.ApplicationPackages); i++ {
		if swag.IsZero(m.ApplicationPackages[i]) { // not required
			continue
		}

		if m.ApplicationPackages[i] != nil {
			if err := m.ApplicationPackages[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("applicationPackages" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("applicationPackages" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *APIImageLookupRequest) validateOsversion(formats strfmt.Registry) error {

	if err := validate.Required("osversion", "body", m.Osversion); err != nil {
		return err
	}

	return nil
}

func (m *APIImageLookupRequest) validatePackages(formats strfmt.Registry) error {

	if err := validate.Required("packages", "body", m.Packages); err != nil {
		return err
	}

	for i := 0; i < len(m.Packages); i++ {
		if swag.IsZero(m.Packages[i]) { // not required
			continue
		}

		if m.Packages[i] != nil {
			if err := m.Packages[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("packages" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("packages" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this api image lookup request based on the context it is used
func (m *APIImageLookupRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplicationPackages(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePackages(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APIImageLookupRequest) contextValidateApplicationPackages(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ApplicationPackages); i++ {

		if m.ApplicationPackages[i] != nil {

			if swag.IsZero(m.ApplicationPackages[i]) { // not required
				return nil
			}

			if err := m.ApplicationPackages[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("applicationPackages" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("applicationPackages" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *APIImageLookupRequest) contextValidatePackages(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Packages); i++ {

		if m.Packages[i] != nil {

			if swag.IsZero(m.Packages[i]) { // not required
				return nil
			}

			if err := m.Packages[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("packages" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("packages" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *APIImageLookupRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *APIImageLookupRequest) UnmarshalBinary(b []byte) error {
	var res APIImageLookupRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
