// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// APIIndicatorsReportRequest api indicators report request
//
// swagger:model api.IndicatorsReportRequest
type APIIndicatorsReportRequest struct {

	// from parent
	FromParent bool `json:"from_parent,omitempty"`

	// report format
	// Required: true
	ReportFormat *string `json:"report_format"`

	// search
	// Required: true
	Search *APIIndicatorsSortedSearch `json:"search"`
}

// Validate validates this api indicators report request
func (m *APIIndicatorsReportRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReportFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSearch(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APIIndicatorsReportRequest) validateReportFormat(formats strfmt.Registry) error {

	if err := validate.Required("report_format", "body", m.ReportFormat); err != nil {
		return err
	}

	return nil
}

func (m *APIIndicatorsReportRequest) validateSearch(formats strfmt.Registry) error {

	if err := validate.Required("search", "body", m.Search); err != nil {
		return err
	}

	if m.Search != nil {
		if err := m.Search.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("search")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("search")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this api indicators report request based on the context it is used
func (m *APIIndicatorsReportRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSearch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APIIndicatorsReportRequest) contextValidateSearch(ctx context.Context, formats strfmt.Registry) error {

	if m.Search != nil {

		if err := m.Search.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("search")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("search")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *APIIndicatorsReportRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *APIIndicatorsReportRequest) UnmarshalBinary(b []byte) error {
	var res APIIndicatorsReportRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
