// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// APINotificationExposedDataRecordV1 api notification exposed data record v1
//
// swagger:model api.NotificationExposedDataRecordV1
type APINotificationExposedDataRecordV1 struct {

	// The individual or group who exposed the data
	// Required: true
	Author *string `json:"author"`

	// The ID of the author within Recon
	AuthorID string `json:"author_id,omitempty"`

	// The customer ID
	// Required: true
	Cid *string `json:"cid"`

	// The company of the user
	Company string `json:"company,omitempty"`

	// The date when this entity was created in Recon
	// Required: true
	// Format: date-time
	CreatedDate *strfmt.DateTime `json:"created_date"`

	// The domain where the credentials are valid
	CredentialsDomain string `json:"credentials_domain,omitempty"`

	// The IP where the credentials are valid
	CredentialsIP string `json:"credentials_ip,omitempty"`

	// The URL where the credentials are valid
	CredentialsURL string `json:"credentials_url,omitempty"`

	// The nickname of the user on the impacted site
	DisplayName string `json:"display_name,omitempty"`

	// The domain of the email linked to the impacted site
	Domain string `json:"domain,omitempty"`

	// The email linked to the impacted site
	Email string `json:"email,omitempty"`

	// The approximate date when the event occurred
	// Required: true
	EventDate *string `json:"event_date"`

	// The date when the exposed data was posted online
	// Required: true
	// Format: date-time
	ExposureDate *strfmt.DateTime `json:"exposure_date"`

	// Information about the file this record was found in
	File *APIExposedDataFileDetailsV1 `json:"file,omitempty"`

	// User financial information
	Financial *APIExposedDataRecordFinancialV1 `json:"financial,omitempty"`

	// The full name of the user on the impacted site
	FullName string `json:"full_name,omitempty"`

	// The algorithm used to hash the password
	HashType string `json:"hash_type,omitempty"`

	// The ID of this entity
	// Required: true
	ID *string `json:"id"`

	// The users job at the company
	JobPosition string `json:"job_position,omitempty"`

	// User location information
	Location *APIExposedDataRecordLocationV1 `json:"location,omitempty"`

	// login id
	LoginID string `json:"login_id,omitempty"`

	// The ID of the parent notification associated with this entity
	// Required: true
	NotificationID *string `json:"notification_id"`

	// The password used for login
	Password string `json:"password,omitempty"`

	// The password hash
	PasswordHash string `json:"password_hash,omitempty"`

	// The password salt
	PasswordSalt string `json:"password_salt,omitempty"`

	// The phone number of the user on the impacted site
	PhoneNumber string `json:"phone_number,omitempty"`

	// raw intel id
	// Required: true
	RawIntelID *string `json:"raw_intel_id"`

	// Metadata about the rule that generated this entity
	// Required: true
	Rule *APIRuleDetailsV1 `json:"rule"`

	// The source where this entity was found
	// Required: true
	Site *string `json:"site"`

	// The ID of the site within Recon
	SiteID string `json:"site_id,omitempty"`

	// User social media information
	Social *APIExposedDataRecordSocialV1 `json:"social,omitempty"`

	// The category of the source where this entity was found
	// Required: true
	SourceCategory *string `json:"source_category"`

	// The ID of the user on the impacted site
	UserID string `json:"user_id,omitempty"`

	// The IP of the user on the impacted site
	UserIP string `json:"user_ip,omitempty"`

	// user uuid
	// Required: true
	UserUUID *string `json:"user_uuid"`
}

// Validate validates this api notification exposed data record v1
func (m *APINotificationExposedDataRecordV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuthor(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEventDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExposureDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFinancial(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNotificationID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRawIntelID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRule(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSite(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSocial(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSourceCategory(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APINotificationExposedDataRecordV1) validateAuthor(formats strfmt.Registry) error {

	if err := validate.Required("author", "body", m.Author); err != nil {
		return err
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateCreatedDate(formats strfmt.Registry) error {

	if err := validate.Required("created_date", "body", m.CreatedDate); err != nil {
		return err
	}

	if err := validate.FormatOf("created_date", "body", "date-time", m.CreatedDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateEventDate(formats strfmt.Registry) error {

	if err := validate.Required("event_date", "body", m.EventDate); err != nil {
		return err
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateExposureDate(formats strfmt.Registry) error {

	if err := validate.Required("exposure_date", "body", m.ExposureDate); err != nil {
		return err
	}

	if err := validate.FormatOf("exposure_date", "body", "date-time", m.ExposureDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateFile(formats strfmt.Registry) error {
	if swag.IsZero(m.File) { // not required
		return nil
	}

	if m.File != nil {
		if err := m.File.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("file")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("file")
			}
			return err
		}
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateFinancial(formats strfmt.Registry) error {
	if swag.IsZero(m.Financial) { // not required
		return nil
	}

	if m.Financial != nil {
		if err := m.Financial.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("financial")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("financial")
			}
			return err
		}
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateNotificationID(formats strfmt.Registry) error {

	if err := validate.Required("notification_id", "body", m.NotificationID); err != nil {
		return err
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateRawIntelID(formats strfmt.Registry) error {

	if err := validate.Required("raw_intel_id", "body", m.RawIntelID); err != nil {
		return err
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateRule(formats strfmt.Registry) error {

	if err := validate.Required("rule", "body", m.Rule); err != nil {
		return err
	}

	if m.Rule != nil {
		if err := m.Rule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rule")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("rule")
			}
			return err
		}
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateSite(formats strfmt.Registry) error {

	if err := validate.Required("site", "body", m.Site); err != nil {
		return err
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateSocial(formats strfmt.Registry) error {
	if swag.IsZero(m.Social) { // not required
		return nil
	}

	if m.Social != nil {
		if err := m.Social.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("social")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("social")
			}
			return err
		}
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateSourceCategory(formats strfmt.Registry) error {

	if err := validate.Required("source_category", "body", m.SourceCategory); err != nil {
		return err
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) validateUserUUID(formats strfmt.Registry) error {

	if err := validate.Required("user_uuid", "body", m.UserUUID); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this api notification exposed data record v1 based on the context it is used
func (m *APINotificationExposedDataRecordV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFinancial(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSocial(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APINotificationExposedDataRecordV1) contextValidateFile(ctx context.Context, formats strfmt.Registry) error {

	if m.File != nil {

		if swag.IsZero(m.File) { // not required
			return nil
		}

		if err := m.File.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("file")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("file")
			}
			return err
		}
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) contextValidateFinancial(ctx context.Context, formats strfmt.Registry) error {

	if m.Financial != nil {

		if swag.IsZero(m.Financial) { // not required
			return nil
		}

		if err := m.Financial.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("financial")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("financial")
			}
			return err
		}
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) contextValidateRule(ctx context.Context, formats strfmt.Registry) error {

	if m.Rule != nil {

		if err := m.Rule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rule")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("rule")
			}
			return err
		}
	}

	return nil
}

func (m *APINotificationExposedDataRecordV1) contextValidateSocial(ctx context.Context, formats strfmt.Registry) error {

	if m.Social != nil {

		if swag.IsZero(m.Social) { // not required
			return nil
		}

		if err := m.Social.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("social")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("social")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *APINotificationExposedDataRecordV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *APINotificationExposedDataRecordV1) UnmarshalBinary(b []byte) error {
	var res APINotificationExposedDataRecordV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
