// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// APIRuleUpdateV1 api rule update v1
//
// swagger:model api.RuleUpdateV1
type APIRuleUpdateV1 struct {

	// description
	// Required: true
	Description *string `json:"description"`

	// disposition id
	// Required: true
	DispositionID *int32 `json:"disposition_id"`

	// enabled
	// Required: true
	Enabled *bool `json:"enabled"`

	// field values
	// Required: true
	FieldValues []*DomainFieldValue `json:"field_values"`

	// instance id
	// Required: true
	InstanceID *string `json:"instance_id"`

	// name
	// Required: true
	Name *string `json:"name"`

	// pattern severity
	// Required: true
	PatternSeverity *string `json:"pattern_severity"`

	// rulegroup version
	// Required: true
	RulegroupVersion *int64 `json:"rulegroup_version"`
}

// Validate validates this api rule update v1
func (m *APIRuleUpdateV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDescription(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDispositionID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEnabled(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFieldValues(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInstanceID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePatternSeverity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRulegroupVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APIRuleUpdateV1) validateDescription(formats strfmt.Registry) error {

	if err := validate.Required("description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *APIRuleUpdateV1) validateDispositionID(formats strfmt.Registry) error {

	if err := validate.Required("disposition_id", "body", m.DispositionID); err != nil {
		return err
	}

	return nil
}

func (m *APIRuleUpdateV1) validateEnabled(formats strfmt.Registry) error {

	if err := validate.Required("enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *APIRuleUpdateV1) validateFieldValues(formats strfmt.Registry) error {

	if err := validate.Required("field_values", "body", m.FieldValues); err != nil {
		return err
	}

	for i := 0; i < len(m.FieldValues); i++ {
		if swag.IsZero(m.FieldValues[i]) { // not required
			continue
		}

		if m.FieldValues[i] != nil {
			if err := m.FieldValues[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("field_values" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("field_values" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *APIRuleUpdateV1) validateInstanceID(formats strfmt.Registry) error {

	if err := validate.Required("instance_id", "body", m.InstanceID); err != nil {
		return err
	}

	return nil
}

func (m *APIRuleUpdateV1) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *APIRuleUpdateV1) validatePatternSeverity(formats strfmt.Registry) error {

	if err := validate.Required("pattern_severity", "body", m.PatternSeverity); err != nil {
		return err
	}

	return nil
}

func (m *APIRuleUpdateV1) validateRulegroupVersion(formats strfmt.Registry) error {

	if err := validate.Required("rulegroup_version", "body", m.RulegroupVersion); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this api rule update v1 based on the context it is used
func (m *APIRuleUpdateV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFieldValues(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APIRuleUpdateV1) contextValidateFieldValues(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.FieldValues); i++ {

		if m.FieldValues[i] != nil {

			if swag.IsZero(m.FieldValues[i]) { // not required
				return nil
			}

			if err := m.FieldValues[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("field_values" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("field_values" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *APIRuleUpdateV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *APIRuleUpdateV1) UnmarshalBinary(b []byte) error {
	var res APIRuleUpdateV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
