// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// APITokenDetailsResourceV1 api token details resource v1
//
// swagger:model api.tokenDetailsResourceV1
type APITokenDetailsResourceV1 struct {

	// created timestamp
	// Required: true
	// Format: date-time
	CreatedTimestamp *strfmt.DateTime `json:"created_timestamp"`

	// expires timestamp
	// Required: true
	// Format: date-time
	ExpiresTimestamp *strfmt.DateTime `json:"expires_timestamp"`

	// id
	// Required: true
	ID *string `json:"id"`

	// label
	// Required: true
	Label *string `json:"label"`

	// last used timestamp
	// Required: true
	// Format: date-time
	LastUsedTimestamp *strfmt.DateTime `json:"last_used_timestamp"`

	// revoked timestamp
	// Required: true
	// Format: date-time
	RevokedTimestamp *strfmt.DateTime `json:"revoked_timestamp"`

	// status
	// Required: true
	Status *string `json:"status"`

	// type
	// Required: true
	Type *string `json:"type"`

	// value
	// Required: true
	Value *string `json:"value"`
}

// Validate validates this api token details resource v1
func (m *APITokenDetailsResourceV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreatedTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiresTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLabel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUsedTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRevokedTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateValue(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APITokenDetailsResourceV1) validateCreatedTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("created_timestamp", "body", m.CreatedTimestamp); err != nil {
		return err
	}

	if err := validate.FormatOf("created_timestamp", "body", "date-time", m.CreatedTimestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *APITokenDetailsResourceV1) validateExpiresTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("expires_timestamp", "body", m.ExpiresTimestamp); err != nil {
		return err
	}

	if err := validate.FormatOf("expires_timestamp", "body", "date-time", m.ExpiresTimestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *APITokenDetailsResourceV1) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *APITokenDetailsResourceV1) validateLabel(formats strfmt.Registry) error {

	if err := validate.Required("label", "body", m.Label); err != nil {
		return err
	}

	return nil
}

func (m *APITokenDetailsResourceV1) validateLastUsedTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("last_used_timestamp", "body", m.LastUsedTimestamp); err != nil {
		return err
	}

	if err := validate.FormatOf("last_used_timestamp", "body", "date-time", m.LastUsedTimestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *APITokenDetailsResourceV1) validateRevokedTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("revoked_timestamp", "body", m.RevokedTimestamp); err != nil {
		return err
	}

	if err := validate.FormatOf("revoked_timestamp", "body", "date-time", m.RevokedTimestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *APITokenDetailsResourceV1) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *APITokenDetailsResourceV1) validateType(formats strfmt.Registry) error {

	if err := validate.Required("type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *APITokenDetailsResourceV1) validateValue(formats strfmt.Registry) error {

	if err := validate.Required("value", "body", m.Value); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this api token details resource v1 based on context it is used
func (m *APITokenDetailsResourceV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *APITokenDetailsResourceV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *APITokenDetailsResourceV1) UnmarshalBinary(b []byte) error {
	var res APITokenDetailsResourceV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
