// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// BaseSetPolicyPrecedenceReqV1 Sets the precedence order for policies of a given platform
//
// swagger:model base.SetPolicyPrecedenceReqV1
type BaseSetPolicyPrecedenceReqV1 struct {

	// The ids of all current prevention policies for the platform specified. The precedence will be set in the order the ids are specified
	// Required: true
	Ids []string `json:"ids"`

	// The name of the platform for which to set precedence
	// Required: true
	// Enum: [Windows Mac Linux]
	PlatformName *string `json:"platform_name"`
}

// Validate validates this base set policy precedence req v1
func (m *BaseSetPolicyPrecedenceReqV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIds(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePlatformName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BaseSetPolicyPrecedenceReqV1) validateIds(formats strfmt.Registry) error {

	if err := validate.Required("ids", "body", m.Ids); err != nil {
		return err
	}

	return nil
}

var baseSetPolicyPrecedenceReqV1TypePlatformNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["Windows","Mac","Linux"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		baseSetPolicyPrecedenceReqV1TypePlatformNamePropEnum = append(baseSetPolicyPrecedenceReqV1TypePlatformNamePropEnum, v)
	}
}

const (

	// BaseSetPolicyPrecedenceReqV1PlatformNameWindows captures enum value "Windows"
	BaseSetPolicyPrecedenceReqV1PlatformNameWindows string = "Windows"

	// BaseSetPolicyPrecedenceReqV1PlatformNameMac captures enum value "Mac"
	BaseSetPolicyPrecedenceReqV1PlatformNameMac string = "Mac"

	// BaseSetPolicyPrecedenceReqV1PlatformNameLinux captures enum value "Linux"
	BaseSetPolicyPrecedenceReqV1PlatformNameLinux string = "Linux"
)

// prop value enum
func (m *BaseSetPolicyPrecedenceReqV1) validatePlatformNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, baseSetPolicyPrecedenceReqV1TypePlatformNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BaseSetPolicyPrecedenceReqV1) validatePlatformName(formats strfmt.Registry) error {

	if err := validate.Required("platform_name", "body", m.PlatformName); err != nil {
		return err
	}

	// value enum
	if err := m.validatePlatformNameEnum("platform_name", "body", *m.PlatformName); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this base set policy precedence req v1 based on context it is used
func (m *BaseSetPolicyPrecedenceReqV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BaseSetPolicyPrecedenceReqV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BaseSetPolicyPrecedenceReqV1) UnmarshalBinary(b []byte) error {
	var res BaseSetPolicyPrecedenceReqV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
