// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ClassificationLabel classification label
//
// swagger:model classification.Label
type ClassificationLabel struct {

	// criteria
	Criteria []*ClassificationCriteria `json:"criteria"`

	// dynamic
	Dynamic bool `json:"dynamic,omitempty"`

	// global
	Global bool `json:"global,omitempty"`

	// group
	Group string `json:"group,omitempty"`

	// id
	ID int32 `json:"id,omitempty"`

	// name
	Name string `json:"name,omitempty"`
}

// Validate validates this classification label
func (m *ClassificationLabel) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCriteria(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClassificationLabel) validateCriteria(formats strfmt.Registry) error {
	if swag.IsZero(m.Criteria) { // not required
		return nil
	}

	for i := 0; i < len(m.Criteria); i++ {
		if swag.IsZero(m.Criteria[i]) { // not required
			continue
		}

		if m.Criteria[i] != nil {
			if err := m.Criteria[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("criteria" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this classification label based on the context it is used
func (m *ClassificationLabel) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClassificationLabel) contextValidateCriteria(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Criteria); i++ {

		if m.Criteria[i] != nil {

			if swag.IsZero(m.Criteria[i]) { // not required
				return nil
			}

			if err := m.Criteria[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("criteria" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClassificationLabel) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClassificationLabel) UnmarshalBinary(b []byte) error {
	var res ClassificationLabel
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
