// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ClientArchiveWithFilesV1 client archive with files v1
//
// swagger:model client.ArchiveWithFilesV1
type ClientArchiveWithFilesV1 struct {

	// error
	Error string `json:"error,omitempty"`

	// files
	Files []string `json:"files"`

	// mime type
	// Required: true
	MimeType *string `json:"mime_type"`

	// name
	// Required: true
	Name *string `json:"name"`

	// sha256
	Sha256 string `json:"sha256,omitempty"`

	// size
	// Required: true
	Size *int64 `json:"size"`

	// status
	// Required: true
	Status *string `json:"status"`

	// upload timestamp
	// Required: true
	UploadTimestamp *string `json:"upload_timestamp"`
}

// Validate validates this client archive with files v1
func (m *ClientArchiveWithFilesV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMimeType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUploadTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientArchiveWithFilesV1) validateMimeType(formats strfmt.Registry) error {

	if err := validate.Required("mime_type", "body", m.MimeType); err != nil {
		return err
	}

	return nil
}

func (m *ClientArchiveWithFilesV1) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ClientArchiveWithFilesV1) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *ClientArchiveWithFilesV1) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClientArchiveWithFilesV1) validateUploadTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("upload_timestamp", "body", m.UploadTimestamp); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this client archive with files v1 based on context it is used
func (m *ClientArchiveWithFilesV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClientArchiveWithFilesV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClientArchiveWithFilesV1) UnmarshalBinary(b []byte) error {
	var res ClientArchiveWithFilesV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
