// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DetectionAggregateIndicator detection aggregate indicator
//
// swagger:model detection.AggregateIndicator
type DetectionAggregateIndicator struct {

	// actors
	Actors []string `json:"actors"`

	// first seen
	// Format: date-time
	FirstSeen strfmt.DateTime `json:"first_seen,omitempty"`

	// malicious ip
	MaliciousIP bool `json:"malicious_ip,omitempty"`

	// malware families
	MalwareFamilies []string `json:"malware_families"`

	// modified at
	// Format: date-time
	ModifiedAt strfmt.DateTime `json:"modified_at,omitempty"`

	// type
	Type string `json:"type,omitempty"`

	// value
	Value string `json:"value,omitempty"`
}

// Validate validates this detection aggregate indicator
func (m *DetectionAggregateIndicator) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFirstSeen(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateModifiedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DetectionAggregateIndicator) validateFirstSeen(formats strfmt.Registry) error {
	if swag.IsZero(m.FirstSeen) { // not required
		return nil
	}

	if err := validate.FormatOf("first_seen", "body", "date-time", m.FirstSeen.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DetectionAggregateIndicator) validateModifiedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.ModifiedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("modified_at", "body", "date-time", m.ModifiedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this detection aggregate indicator based on context it is used
func (m *DetectionAggregateIndicator) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DetectionAggregateIndicator) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DetectionAggregateIndicator) UnmarshalBinary(b []byte) error {
	var res DetectionAggregateIndicator
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
