// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// DetectionInventoryEnrichment detection inventory enrichment
//
// swagger:model detection.InventoryEnrichment
type DetectionInventoryEnrichment struct {

	// document ids
	DocumentIds []string `json:"document_ids"`

	// enrichment type
	EnrichmentType string `json:"enrichment_type,omitempty"`

	// host
	Host []*DetectionEnrichmentHost `json:"host"`
}

// Validate validates this detection inventory enrichment
func (m *DetectionInventoryEnrichment) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHost(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DetectionInventoryEnrichment) validateHost(formats strfmt.Registry) error {
	if swag.IsZero(m.Host) { // not required
		return nil
	}

	for i := 0; i < len(m.Host); i++ {
		if swag.IsZero(m.Host[i]) { // not required
			continue
		}

		if m.Host[i] != nil {
			if err := m.Host[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("host" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("host" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this detection inventory enrichment based on the context it is used
func (m *DetectionInventoryEnrichment) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHost(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DetectionInventoryEnrichment) contextValidateHost(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Host); i++ {

		if m.Host[i] != nil {

			if swag.IsZero(m.Host[i]) { // not required
				return nil
			}

			if err := m.Host[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("host" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("host" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DetectionInventoryEnrichment) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DetectionInventoryEnrichment) UnmarshalBinary(b []byte) error {
	var res DetectionInventoryEnrichment
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
