// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DetectsBehavior detects behavior
//
// swagger:model detects.Behavior
type DetectsBehavior struct {

	// alleged filetype
	// Required: true
	AllegedFiletype *string `json:"alleged_filetype"`

	// behavior id
	// Required: true
	BehaviorID *string `json:"behavior_id"`

	// cmdline
	// Required: true
	Cmdline *string `json:"cmdline"`

	// confidence
	// Required: true
	Confidence *int32 `json:"confidence"`

	// container id
	ContainerID string `json:"container_id,omitempty"`

	// control graph id
	// Required: true
	ControlGraphID *string `json:"control_graph_id"`

	// description
	// Required: true
	Description *string `json:"description"`

	// device id
	// Required: true
	DeviceID *string `json:"device_id"`

	// display name
	// Required: true
	DisplayName *string `json:"display_name"`

	// filename
	// Required: true
	Filename *string `json:"filename"`

	// filepath
	// Required: true
	Filepath *string `json:"filepath"`

	// ioc description
	// Required: true
	IocDescription *string `json:"ioc_description"`

	// ioc source
	// Required: true
	IocSource *string `json:"ioc_source"`

	// ioc type
	// Required: true
	IocType *string `json:"ioc_type"`

	// ioc value
	// Required: true
	IocValue *string `json:"ioc_value"`

	// md5
	// Required: true
	Md5 *string `json:"md5"`

	// objective
	// Required: true
	Objective *string `json:"objective"`

	// parent details
	// Required: true
	ParentDetails *DetectsParentDetails `json:"parent_details"`

	// pattern disposition
	// Required: true
	PatternDisposition *int32 `json:"pattern_disposition"`

	// pattern disposition details
	// Required: true
	PatternDispositionDetails *PatterndispositionPatternDisposition `json:"pattern_disposition_details"`

	// rule instance id
	RuleInstanceID string `json:"rule_instance_id,omitempty"`

	// rule instance version
	RuleInstanceVersion int32 `json:"rule_instance_version,omitempty"`

	// scenario
	// Required: true
	Scenario *string `json:"scenario"`

	// severity
	// Required: true
	Severity *int32 `json:"severity"`

	// sha256
	// Required: true
	Sha256 *string `json:"sha256"`

	// tactic
	// Required: true
	Tactic *string `json:"tactic"`

	// tactic id
	// Required: true
	TacticID *string `json:"tactic_id"`

	// technique
	// Required: true
	Technique *string `json:"technique"`

	// technique id
	// Required: true
	TechniqueID *string `json:"technique_id"`

	// template instance id
	TemplateInstanceID string `json:"template_instance_id,omitempty"`

	// timestamp
	// Required: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp"`

	// triggering process graph id
	// Required: true
	TriggeringProcessGraphID *string `json:"triggering_process_graph_id"`

	// user id
	// Required: true
	UserID *string `json:"user_id"`

	// user name
	// Required: true
	UserName *string `json:"user_name"`
}

// Validate validates this detects behavior
func (m *DetectsBehavior) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAllegedFiletype(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBehaviorID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCmdline(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfidence(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateControlGraphID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDescription(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeviceID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDisplayName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilename(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilepath(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIocDescription(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIocSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIocType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIocValue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMd5(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjective(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePatternDisposition(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePatternDispositionDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScenario(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSeverity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSha256(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTactic(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTacticID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTechnique(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTechniqueID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTriggeringProcessGraphID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DetectsBehavior) validateAllegedFiletype(formats strfmt.Registry) error {

	if err := validate.Required("alleged_filetype", "body", m.AllegedFiletype); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateBehaviorID(formats strfmt.Registry) error {

	if err := validate.Required("behavior_id", "body", m.BehaviorID); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateCmdline(formats strfmt.Registry) error {

	if err := validate.Required("cmdline", "body", m.Cmdline); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateConfidence(formats strfmt.Registry) error {

	if err := validate.Required("confidence", "body", m.Confidence); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateControlGraphID(formats strfmt.Registry) error {

	if err := validate.Required("control_graph_id", "body", m.ControlGraphID); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateDescription(formats strfmt.Registry) error {

	if err := validate.Required("description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateDeviceID(formats strfmt.Registry) error {

	if err := validate.Required("device_id", "body", m.DeviceID); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateDisplayName(formats strfmt.Registry) error {

	if err := validate.Required("display_name", "body", m.DisplayName); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateFilename(formats strfmt.Registry) error {

	if err := validate.Required("filename", "body", m.Filename); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateFilepath(formats strfmt.Registry) error {

	if err := validate.Required("filepath", "body", m.Filepath); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateIocDescription(formats strfmt.Registry) error {

	if err := validate.Required("ioc_description", "body", m.IocDescription); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateIocSource(formats strfmt.Registry) error {

	if err := validate.Required("ioc_source", "body", m.IocSource); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateIocType(formats strfmt.Registry) error {

	if err := validate.Required("ioc_type", "body", m.IocType); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateIocValue(formats strfmt.Registry) error {

	if err := validate.Required("ioc_value", "body", m.IocValue); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateMd5(formats strfmt.Registry) error {

	if err := validate.Required("md5", "body", m.Md5); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateObjective(formats strfmt.Registry) error {

	if err := validate.Required("objective", "body", m.Objective); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateParentDetails(formats strfmt.Registry) error {

	if err := validate.Required("parent_details", "body", m.ParentDetails); err != nil {
		return err
	}

	if m.ParentDetails != nil {
		if err := m.ParentDetails.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("parent_details")
			}
			return err
		}
	}

	return nil
}

func (m *DetectsBehavior) validatePatternDisposition(formats strfmt.Registry) error {

	if err := validate.Required("pattern_disposition", "body", m.PatternDisposition); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validatePatternDispositionDetails(formats strfmt.Registry) error {

	if err := validate.Required("pattern_disposition_details", "body", m.PatternDispositionDetails); err != nil {
		return err
	}

	if m.PatternDispositionDetails != nil {
		if err := m.PatternDispositionDetails.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pattern_disposition_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pattern_disposition_details")
			}
			return err
		}
	}

	return nil
}

func (m *DetectsBehavior) validateScenario(formats strfmt.Registry) error {

	if err := validate.Required("scenario", "body", m.Scenario); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateSeverity(formats strfmt.Registry) error {

	if err := validate.Required("severity", "body", m.Severity); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateSha256(formats strfmt.Registry) error {

	if err := validate.Required("sha256", "body", m.Sha256); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateTactic(formats strfmt.Registry) error {

	if err := validate.Required("tactic", "body", m.Tactic); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateTacticID(formats strfmt.Registry) error {

	if err := validate.Required("tactic_id", "body", m.TacticID); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateTechnique(formats strfmt.Registry) error {

	if err := validate.Required("technique", "body", m.Technique); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateTechniqueID(formats strfmt.Registry) error {

	if err := validate.Required("technique_id", "body", m.TechniqueID); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateTriggeringProcessGraphID(formats strfmt.Registry) error {

	if err := validate.Required("triggering_process_graph_id", "body", m.TriggeringProcessGraphID); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateUserID(formats strfmt.Registry) error {

	if err := validate.Required("user_id", "body", m.UserID); err != nil {
		return err
	}

	return nil
}

func (m *DetectsBehavior) validateUserName(formats strfmt.Registry) error {

	if err := validate.Required("user_name", "body", m.UserName); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this detects behavior based on the context it is used
func (m *DetectsBehavior) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateParentDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePatternDispositionDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DetectsBehavior) contextValidateParentDetails(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentDetails != nil {

		if err := m.ParentDetails.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("parent_details")
			}
			return err
		}
	}

	return nil
}

func (m *DetectsBehavior) contextValidatePatternDispositionDetails(ctx context.Context, formats strfmt.Registry) error {

	if m.PatternDispositionDetails != nil {

		if err := m.PatternDispositionDetails.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pattern_disposition_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pattern_disposition_details")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DetectsBehavior) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DetectsBehavior) UnmarshalBinary(b []byte) error {
	var res DetectsBehavior
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
