// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DeviceControlCreatePolicyReqV1 device control create policy req v1
//
// swagger:model device_control.CreatePolicyReqV1
type DeviceControlCreatePolicyReqV1 struct {

	// If specified the settings of the DeviceControl policy identified by the id will be used
	CloneID string `json:"clone_id,omitempty"`

	// The description to use when creating the policy
	Description string `json:"description,omitempty"`

	// The name to use when creating the policy
	// Required: true
	Name *string `json:"name"`

	// The name of the platform
	// Required: true
	// Enum: [Windows Mac Linux]
	PlatformName *string `json:"platform_name"`

	// The settings to create the policy with
	Settings *DeviceControlSettingsReqV1 `json:"settings,omitempty"`
}

// Validate validates this device control create policy req v1
func (m *DeviceControlCreatePolicyReqV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePlatformName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSettings(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceControlCreatePolicyReqV1) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

var deviceControlCreatePolicyReqV1TypePlatformNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["Windows","Mac","Linux"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		deviceControlCreatePolicyReqV1TypePlatformNamePropEnum = append(deviceControlCreatePolicyReqV1TypePlatformNamePropEnum, v)
	}
}

const (

	// DeviceControlCreatePolicyReqV1PlatformNameWindows captures enum value "Windows"
	DeviceControlCreatePolicyReqV1PlatformNameWindows string = "Windows"

	// DeviceControlCreatePolicyReqV1PlatformNameMac captures enum value "Mac"
	DeviceControlCreatePolicyReqV1PlatformNameMac string = "Mac"

	// DeviceControlCreatePolicyReqV1PlatformNameLinux captures enum value "Linux"
	DeviceControlCreatePolicyReqV1PlatformNameLinux string = "Linux"
)

// prop value enum
func (m *DeviceControlCreatePolicyReqV1) validatePlatformNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, deviceControlCreatePolicyReqV1TypePlatformNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DeviceControlCreatePolicyReqV1) validatePlatformName(formats strfmt.Registry) error {

	if err := validate.Required("platform_name", "body", m.PlatformName); err != nil {
		return err
	}

	// value enum
	if err := m.validatePlatformNameEnum("platform_name", "body", *m.PlatformName); err != nil {
		return err
	}

	return nil
}

func (m *DeviceControlCreatePolicyReqV1) validateSettings(formats strfmt.Registry) error {
	if swag.IsZero(m.Settings) { // not required
		return nil
	}

	if m.Settings != nil {
		if err := m.Settings.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("settings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("settings")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this device control create policy req v1 based on the context it is used
func (m *DeviceControlCreatePolicyReqV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSettings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceControlCreatePolicyReqV1) contextValidateSettings(ctx context.Context, formats strfmt.Registry) error {

	if m.Settings != nil {

		if swag.IsZero(m.Settings) { // not required
			return nil
		}

		if err := m.Settings.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("settings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("settings")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DeviceControlCreatePolicyReqV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DeviceControlCreatePolicyReqV1) UnmarshalBinary(b []byte) error {
	var res DeviceControlCreatePolicyReqV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
