// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DeviceControlExceptionReqV1 device control exception req v1
//
// swagger:model device_control.ExceptionReqV1
type DeviceControlExceptionReqV1 struct {

	// action
	Action string `json:"action,omitempty"`

	// combined id
	CombinedID string `json:"combined_id,omitempty"`

	// description
	Description string `json:"description,omitempty"`

	// expiration time
	// Format: date-time
	ExpirationTime strfmt.DateTime `json:"expiration_time,omitempty"`

	// Unique identifier for an exception
	ID string `json:"id,omitempty"`

	// product id
	ProductID string `json:"product_id,omitempty"`

	// product id decimal
	ProductIDDecimal string `json:"product_id_decimal,omitempty"`

	// product name
	ProductName string `json:"product_name,omitempty"`

	// serial number
	SerialNumber string `json:"serial_number,omitempty"`

	// true indicates using blob syntax USB serial numbers
	UseWildcard bool `json:"use_wildcard,omitempty"`

	// Hexadecimal VendorID used to apply the exception
	VendorID string `json:"vendor_id,omitempty"`

	// Hexadecimal VendorID used to apply the exception
	VendorIDDecimal string `json:"vendor_id_decimal,omitempty"`

	// Vendor Name, optional
	VendorName string `json:"vendor_name,omitempty"`
}

// Validate validates this device control exception req v1
func (m *DeviceControlExceptionReqV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExpirationTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceControlExceptionReqV1) validateExpirationTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpirationTime) { // not required
		return nil
	}

	if err := validate.FormatOf("expiration_time", "body", "date-time", m.ExpirationTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this device control exception req v1 based on context it is used
func (m *DeviceControlExceptionReqV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DeviceControlExceptionReqV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DeviceControlExceptionReqV1) UnmarshalBinary(b []byte) error {
	var res DeviceControlExceptionReqV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
