// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DeviceControlExceptionRespV1 device control exception resp v1
//
// swagger:model device_control.ExceptionRespV1
type DeviceControlExceptionRespV1 struct {

	// action
	Action string `json:"action,omitempty"`

	// USB Class ID to apply the exception. If empty it applies to all classes
	// Required: true
	Class *string `json:"class"`

	// combined id
	CombinedID string `json:"combined_id,omitempty"`

	// description
	Description string `json:"description,omitempty"`

	// expiration time
	// Format: date-time
	ExpirationTime strfmt.DateTime `json:"expiration_time,omitempty"`

	// Unique identifier for an exception
	// Required: true
	ID *string `json:"id"`

	// match method
	MatchMethod string `json:"match_method,omitempty"`

	// product id
	ProductID string `json:"product_id,omitempty"`

	// product id decimal
	ProductIDDecimal string `json:"product_id_decimal,omitempty"`

	// product name
	ProductName string `json:"product_name,omitempty"`

	// serial number
	SerialNumber string `json:"serial_number,omitempty"`

	// Hexadecimal VendorID used to apply the exception
	VendorID string `json:"vendor_id,omitempty"`

	// Hexadecimal VendorID used to apply the exception
	VendorIDDecimal string `json:"vendor_id_decimal,omitempty"`

	// Vendor Name
	VendorName string `json:"vendor_name,omitempty"`
}

// Validate validates this device control exception resp v1
func (m *DeviceControlExceptionRespV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClass(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpirationTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceControlExceptionRespV1) validateClass(formats strfmt.Registry) error {

	if err := validate.Required("class", "body", m.Class); err != nil {
		return err
	}

	return nil
}

func (m *DeviceControlExceptionRespV1) validateExpirationTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpirationTime) { // not required
		return nil
	}

	if err := validate.FormatOf("expiration_time", "body", "date-time", m.ExpirationTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DeviceControlExceptionRespV1) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this device control exception resp v1 based on context it is used
func (m *DeviceControlExceptionRespV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DeviceControlExceptionRespV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DeviceControlExceptionRespV1) UnmarshalBinary(b []byte) error {
	var res DeviceControlExceptionRespV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
