// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DeviceControlSettingsReqV1 device control settings req v1
//
// swagger:model device_control.SettingsReqV1
type DeviceControlSettingsReqV1 struct {

	// Settings that apply to a USB Class
	// Required: true
	Classes []*DeviceControlUSBClassExceptionsReqV1 `json:"classes"`

	// A collection of custom notifications triggered to the end-user when a USB policy is violated
	CustomNotifications *DeviceControlUSBCustomNotifications `json:"custom_notifications,omitempty"`

	// An array of exception IDs to delete from the policy
	// Required: true
	DeleteExceptions []string `json:"delete_exceptions"`

	// Does the end user receives a notification when the policy is violated
	// Required: true
	// Enum: [SILENT NOTIFY_USER]
	EndUserNotification *string `json:"end_user_notification"`

	// How is this policy enforced
	// Required: true
	// Enum: [MONITOR_ONLY MONITOR_ENFORCE]
	EnforcementMode *string `json:"enforcement_mode"`

	// A bool value that enables file metadata functionality on the sensor or not
	EnhancedFileMetadata bool `json:"enhanced_file_metadata,omitempty"`
}

// Validate validates this device control settings req v1
func (m *DeviceControlSettingsReqV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClasses(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCustomNotifications(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeleteExceptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEndUserNotification(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEnforcementMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceControlSettingsReqV1) validateClasses(formats strfmt.Registry) error {

	if err := validate.Required("classes", "body", m.Classes); err != nil {
		return err
	}

	for i := 0; i < len(m.Classes); i++ {
		if swag.IsZero(m.Classes[i]) { // not required
			continue
		}

		if m.Classes[i] != nil {
			if err := m.Classes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("classes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("classes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DeviceControlSettingsReqV1) validateCustomNotifications(formats strfmt.Registry) error {
	if swag.IsZero(m.CustomNotifications) { // not required
		return nil
	}

	if m.CustomNotifications != nil {
		if err := m.CustomNotifications.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("custom_notifications")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("custom_notifications")
			}
			return err
		}
	}

	return nil
}

func (m *DeviceControlSettingsReqV1) validateDeleteExceptions(formats strfmt.Registry) error {

	if err := validate.Required("delete_exceptions", "body", m.DeleteExceptions); err != nil {
		return err
	}

	return nil
}

var deviceControlSettingsReqV1TypeEndUserNotificationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["SILENT","NOTIFY_USER"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		deviceControlSettingsReqV1TypeEndUserNotificationPropEnum = append(deviceControlSettingsReqV1TypeEndUserNotificationPropEnum, v)
	}
}

const (

	// DeviceControlSettingsReqV1EndUserNotificationSILENT captures enum value "SILENT"
	DeviceControlSettingsReqV1EndUserNotificationSILENT string = "SILENT"

	// DeviceControlSettingsReqV1EndUserNotificationNOTIFYUSER captures enum value "NOTIFY_USER"
	DeviceControlSettingsReqV1EndUserNotificationNOTIFYUSER string = "NOTIFY_USER"
)

// prop value enum
func (m *DeviceControlSettingsReqV1) validateEndUserNotificationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, deviceControlSettingsReqV1TypeEndUserNotificationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DeviceControlSettingsReqV1) validateEndUserNotification(formats strfmt.Registry) error {

	if err := validate.Required("end_user_notification", "body", m.EndUserNotification); err != nil {
		return err
	}

	// value enum
	if err := m.validateEndUserNotificationEnum("end_user_notification", "body", *m.EndUserNotification); err != nil {
		return err
	}

	return nil
}

var deviceControlSettingsReqV1TypeEnforcementModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["MONITOR_ONLY","MONITOR_ENFORCE"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		deviceControlSettingsReqV1TypeEnforcementModePropEnum = append(deviceControlSettingsReqV1TypeEnforcementModePropEnum, v)
	}
}

const (

	// DeviceControlSettingsReqV1EnforcementModeMONITORONLY captures enum value "MONITOR_ONLY"
	DeviceControlSettingsReqV1EnforcementModeMONITORONLY string = "MONITOR_ONLY"

	// DeviceControlSettingsReqV1EnforcementModeMONITORENFORCE captures enum value "MONITOR_ENFORCE"
	DeviceControlSettingsReqV1EnforcementModeMONITORENFORCE string = "MONITOR_ENFORCE"
)

// prop value enum
func (m *DeviceControlSettingsReqV1) validateEnforcementModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, deviceControlSettingsReqV1TypeEnforcementModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DeviceControlSettingsReqV1) validateEnforcementMode(formats strfmt.Registry) error {

	if err := validate.Required("enforcement_mode", "body", m.EnforcementMode); err != nil {
		return err
	}

	// value enum
	if err := m.validateEnforcementModeEnum("enforcement_mode", "body", *m.EnforcementMode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this device control settings req v1 based on the context it is used
func (m *DeviceControlSettingsReqV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateClasses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCustomNotifications(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceControlSettingsReqV1) contextValidateClasses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Classes); i++ {

		if m.Classes[i] != nil {

			if swag.IsZero(m.Classes[i]) { // not required
				return nil
			}

			if err := m.Classes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("classes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("classes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DeviceControlSettingsReqV1) contextValidateCustomNotifications(ctx context.Context, formats strfmt.Registry) error {

	if m.CustomNotifications != nil {

		if swag.IsZero(m.CustomNotifications) { // not required
			return nil
		}

		if err := m.CustomNotifications.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("custom_notifications")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("custom_notifications")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DeviceControlSettingsReqV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DeviceControlSettingsReqV1) UnmarshalBinary(b []byte) error {
	var res DeviceControlSettingsReqV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
