// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DeviceControlSettingsRespV1 device control settings resp v1
//
// swagger:model device_control.SettingsRespV1
type DeviceControlSettingsRespV1 struct {

	// List of class_settings this policy applies to
	// Required: true
	Classes []*DeviceControlUSBClassExceptionsResponse `json:"classes"`

	// A collection of custom notifications triggered to the end-user when a USB policy is violated
	CustomNotifications *DeviceControlUSBCustomNotifications `json:"custom_notifications,omitempty"`

	// Does the end user receives a notification when the policy is violated
	// Required: true
	// Enum: [SILENT NOTIFY_USER]
	EndUserNotification *string `json:"end_user_notification"`

	// [How] is this policy enforced
	// Required: true
	// Enum: [MONITOR_ONLY MONITOR_ENFORCE OFF]
	EnforcementMode *string `json:"enforcement_mode"`

	// Is file metadata processor enabled or not? true|false
	// Required: true
	EnhancedFileMetadata *bool `json:"enhanced_file_metadata"`
}

// Validate validates this device control settings resp v1
func (m *DeviceControlSettingsRespV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClasses(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCustomNotifications(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEndUserNotification(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEnforcementMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEnhancedFileMetadata(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceControlSettingsRespV1) validateClasses(formats strfmt.Registry) error {

	if err := validate.Required("classes", "body", m.Classes); err != nil {
		return err
	}

	for i := 0; i < len(m.Classes); i++ {
		if swag.IsZero(m.Classes[i]) { // not required
			continue
		}

		if m.Classes[i] != nil {
			if err := m.Classes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("classes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("classes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DeviceControlSettingsRespV1) validateCustomNotifications(formats strfmt.Registry) error {
	if swag.IsZero(m.CustomNotifications) { // not required
		return nil
	}

	if m.CustomNotifications != nil {
		if err := m.CustomNotifications.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("custom_notifications")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("custom_notifications")
			}
			return err
		}
	}

	return nil
}

var deviceControlSettingsRespV1TypeEndUserNotificationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["SILENT","NOTIFY_USER"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		deviceControlSettingsRespV1TypeEndUserNotificationPropEnum = append(deviceControlSettingsRespV1TypeEndUserNotificationPropEnum, v)
	}
}

const (

	// DeviceControlSettingsRespV1EndUserNotificationSILENT captures enum value "SILENT"
	DeviceControlSettingsRespV1EndUserNotificationSILENT string = "SILENT"

	// DeviceControlSettingsRespV1EndUserNotificationNOTIFYUSER captures enum value "NOTIFY_USER"
	DeviceControlSettingsRespV1EndUserNotificationNOTIFYUSER string = "NOTIFY_USER"
)

// prop value enum
func (m *DeviceControlSettingsRespV1) validateEndUserNotificationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, deviceControlSettingsRespV1TypeEndUserNotificationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DeviceControlSettingsRespV1) validateEndUserNotification(formats strfmt.Registry) error {

	if err := validate.Required("end_user_notification", "body", m.EndUserNotification); err != nil {
		return err
	}

	// value enum
	if err := m.validateEndUserNotificationEnum("end_user_notification", "body", *m.EndUserNotification); err != nil {
		return err
	}

	return nil
}

var deviceControlSettingsRespV1TypeEnforcementModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["MONITOR_ONLY","MONITOR_ENFORCE","OFF"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		deviceControlSettingsRespV1TypeEnforcementModePropEnum = append(deviceControlSettingsRespV1TypeEnforcementModePropEnum, v)
	}
}

const (

	// DeviceControlSettingsRespV1EnforcementModeMONITORONLY captures enum value "MONITOR_ONLY"
	DeviceControlSettingsRespV1EnforcementModeMONITORONLY string = "MONITOR_ONLY"

	// DeviceControlSettingsRespV1EnforcementModeMONITORENFORCE captures enum value "MONITOR_ENFORCE"
	DeviceControlSettingsRespV1EnforcementModeMONITORENFORCE string = "MONITOR_ENFORCE"

	// DeviceControlSettingsRespV1EnforcementModeOFF captures enum value "OFF"
	DeviceControlSettingsRespV1EnforcementModeOFF string = "OFF"
)

// prop value enum
func (m *DeviceControlSettingsRespV1) validateEnforcementModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, deviceControlSettingsRespV1TypeEnforcementModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DeviceControlSettingsRespV1) validateEnforcementMode(formats strfmt.Registry) error {

	if err := validate.Required("enforcement_mode", "body", m.EnforcementMode); err != nil {
		return err
	}

	// value enum
	if err := m.validateEnforcementModeEnum("enforcement_mode", "body", *m.EnforcementMode); err != nil {
		return err
	}

	return nil
}

func (m *DeviceControlSettingsRespV1) validateEnhancedFileMetadata(formats strfmt.Registry) error {

	if err := validate.Required("enhanced_file_metadata", "body", m.EnhancedFileMetadata); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this device control settings resp v1 based on the context it is used
func (m *DeviceControlSettingsRespV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateClasses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCustomNotifications(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceControlSettingsRespV1) contextValidateClasses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Classes); i++ {

		if m.Classes[i] != nil {

			if swag.IsZero(m.Classes[i]) { // not required
				return nil
			}

			if err := m.Classes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("classes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("classes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DeviceControlSettingsRespV1) contextValidateCustomNotifications(ctx context.Context, formats strfmt.Registry) error {

	if m.CustomNotifications != nil {

		if swag.IsZero(m.CustomNotifications) { // not required
			return nil
		}

		if err := m.CustomNotifications.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("custom_notifications")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("custom_notifications")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DeviceControlSettingsRespV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DeviceControlSettingsRespV1) UnmarshalBinary(b []byte) error {
	var res DeviceControlSettingsRespV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
