// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// DeviceControlUSBCustomNotifications device control u s b custom notifications
//
// swagger:model device_control.USBCustomNotifications
type DeviceControlUSBCustomNotifications struct {

	// The custom notification to display when a USB is blocked
	BlockedNotification *DeviceControlUSBCustomNotification `json:"blocked_notification,omitempty"`

	// The custom notification to display when a USB is restricted
	RestrictedNotification *DeviceControlUSBCustomNotification `json:"restricted_notification,omitempty"`
}

// Validate validates this device control u s b custom notifications
func (m *DeviceControlUSBCustomNotifications) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBlockedNotification(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRestrictedNotification(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceControlUSBCustomNotifications) validateBlockedNotification(formats strfmt.Registry) error {
	if swag.IsZero(m.BlockedNotification) { // not required
		return nil
	}

	if m.BlockedNotification != nil {
		if err := m.BlockedNotification.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("blocked_notification")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("blocked_notification")
			}
			return err
		}
	}

	return nil
}

func (m *DeviceControlUSBCustomNotifications) validateRestrictedNotification(formats strfmt.Registry) error {
	if swag.IsZero(m.RestrictedNotification) { // not required
		return nil
	}

	if m.RestrictedNotification != nil {
		if err := m.RestrictedNotification.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restricted_notification")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("restricted_notification")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this device control u s b custom notifications based on the context it is used
func (m *DeviceControlUSBCustomNotifications) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBlockedNotification(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRestrictedNotification(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceControlUSBCustomNotifications) contextValidateBlockedNotification(ctx context.Context, formats strfmt.Registry) error {

	if m.BlockedNotification != nil {

		if swag.IsZero(m.BlockedNotification) { // not required
			return nil
		}

		if err := m.BlockedNotification.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("blocked_notification")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("blocked_notification")
			}
			return err
		}
	}

	return nil
}

func (m *DeviceControlUSBCustomNotifications) contextValidateRestrictedNotification(ctx context.Context, formats strfmt.Registry) error {

	if m.RestrictedNotification != nil {

		if swag.IsZero(m.RestrictedNotification) { // not required
			return nil
		}

		if err := m.RestrictedNotification.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restricted_notification")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("restricted_notification")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DeviceControlUSBCustomNotifications) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DeviceControlUSBCustomNotifications) UnmarshalBinary(b []byte) error {
	var res DeviceControlUSBCustomNotifications
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
