// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DeviceDevicePolicy device device policy
//
// swagger:model device.DevicePolicy
type DeviceDevicePolicy struct {

	// applied
	Applied bool `json:"applied,omitempty"`

	// applied date
	// Format: date-time
	AppliedDate strfmt.DateTime `json:"applied_date,omitempty"`

	// assigned date
	// Format: date-time
	AssignedDate strfmt.DateTime `json:"assigned_date,omitempty"`

	// exempt
	Exempt bool `json:"exempt,omitempty"`

	// policy id
	// Required: true
	PolicyID *string `json:"policy_id"`

	// policy type
	// Required: true
	PolicyType *string `json:"policy_type"`

	// rule groups
	RuleGroups []string `json:"rule_groups"`

	// rule set id
	RuleSetID string `json:"rule_set_id,omitempty"`

	// settings hash
	SettingsHash string `json:"settings_hash,omitempty"`

	// uninstall protection
	UninstallProtection string `json:"uninstall_protection,omitempty"`
}

// Validate validates this device device policy
func (m *DeviceDevicePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAppliedDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAssignedDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicyID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicyType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DeviceDevicePolicy) validateAppliedDate(formats strfmt.Registry) error {
	if swag.IsZero(m.AppliedDate) { // not required
		return nil
	}

	if err := validate.FormatOf("applied_date", "body", "date-time", m.AppliedDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DeviceDevicePolicy) validateAssignedDate(formats strfmt.Registry) error {
	if swag.IsZero(m.AssignedDate) { // not required
		return nil
	}

	if err := validate.FormatOf("assigned_date", "body", "date-time", m.AssignedDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DeviceDevicePolicy) validatePolicyID(formats strfmt.Registry) error {

	if err := validate.Required("policy_id", "body", m.PolicyID); err != nil {
		return err
	}

	return nil
}

func (m *DeviceDevicePolicy) validatePolicyType(formats strfmt.Registry) error {

	if err := validate.Required("policy_type", "body", m.PolicyType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this device device policy based on context it is used
func (m *DeviceDevicePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DeviceDevicePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DeviceDevicePolicy) UnmarshalBinary(b []byte) error {
	var res DeviceDevicePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
