// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainAWSD4CAccountV1 domain a w s d4 c account v1
//
// swagger:model domain.AWSD4CAccountV1
type DomainAWSD4CAccountV1 struct {

	// 12 digit AWS provided unique identifier for the account.
	AccountID string `json:"account_id,omitempty"`

	// cid
	Cid string `json:"cid,omitempty"`

	// iam role arn
	IamRoleArn string `json:"iam_role_arn,omitempty"`

	// intermediate role arn
	IntermediateRoleArn string `json:"intermediate_role_arn,omitempty"`

	// organization
	Organization *DomainAWSD4COrganizationAccountV1 `json:"organization,omitempty"`

	// status
	// Required: true
	Status *string `json:"status"`
}

// Validate validates this domain a w s d4 c account v1
func (m *DomainAWSD4CAccountV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateOrganization(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAWSD4CAccountV1) validateOrganization(formats strfmt.Registry) error {
	if swag.IsZero(m.Organization) { // not required
		return nil
	}

	if m.Organization != nil {
		if err := m.Organization.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("organization")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("organization")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAWSD4CAccountV1) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this domain a w s d4 c account v1 based on the context it is used
func (m *DomainAWSD4CAccountV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateOrganization(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAWSD4CAccountV1) contextValidateOrganization(ctx context.Context, formats strfmt.Registry) error {

	if m.Organization != nil {

		if swag.IsZero(m.Organization) { // not required
			return nil
		}

		if err := m.Organization.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("organization")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("organization")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainAWSD4CAccountV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainAWSD4CAccountV1) UnmarshalBinary(b []byte) error {
	var res DomainAWSD4CAccountV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
