// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainActionParameter Action to be performed.
//
// swagger:model domain.ActionParameter
type DomainActionParameter struct {

	// Action name.
	// Required: true
	// Enum: [add_tag delete_tag update_name update_description update_assigned_to update_assigned_to_name unassign update_status add_comment close_with_descriptor]
	Name *string `json:"name"`

	// Value for action specified.
	// Required: true
	Value *string `json:"value"`
}

// Validate validates this domain action parameter
func (m *DomainActionParameter) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateValue(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var domainActionParameterTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["add_tag","delete_tag","update_name","update_description","update_assigned_to","update_assigned_to_name","unassign","update_status","add_comment","close_with_descriptor"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		domainActionParameterTypeNamePropEnum = append(domainActionParameterTypeNamePropEnum, v)
	}
}

const (

	// DomainActionParameterNameAddTag captures enum value "add_tag"
	DomainActionParameterNameAddTag string = "add_tag"

	// DomainActionParameterNameDeleteTag captures enum value "delete_tag"
	DomainActionParameterNameDeleteTag string = "delete_tag"

	// DomainActionParameterNameUpdateName captures enum value "update_name"
	DomainActionParameterNameUpdateName string = "update_name"

	// DomainActionParameterNameUpdateDescription captures enum value "update_description"
	DomainActionParameterNameUpdateDescription string = "update_description"

	// DomainActionParameterNameUpdateAssignedTo captures enum value "update_assigned_to"
	DomainActionParameterNameUpdateAssignedTo string = "update_assigned_to"

	// DomainActionParameterNameUpdateAssignedToName captures enum value "update_assigned_to_name"
	DomainActionParameterNameUpdateAssignedToName string = "update_assigned_to_name"

	// DomainActionParameterNameUnassign captures enum value "unassign"
	DomainActionParameterNameUnassign string = "unassign"

	// DomainActionParameterNameUpdateStatus captures enum value "update_status"
	DomainActionParameterNameUpdateStatus string = "update_status"

	// DomainActionParameterNameAddComment captures enum value "add_comment"
	DomainActionParameterNameAddComment string = "add_comment"

	// DomainActionParameterNameCloseWithDescriptor captures enum value "close_with_descriptor"
	DomainActionParameterNameCloseWithDescriptor string = "close_with_descriptor"
)

// prop value enum
func (m *DomainActionParameter) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, domainActionParameterTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DomainActionParameter) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	// value enum
	if err := m.validateNameEnum("name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

func (m *DomainActionParameter) validateValue(formats strfmt.Registry) error {

	if err := validate.Required("value", "body", m.Value); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain action parameter based on context it is used
func (m *DomainActionParameter) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainActionParameter) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainActionParameter) UnmarshalBinary(b []byte) error {
	var res DomainActionParameter
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
