// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainActionV1 domain action v1
//
// swagger:model domain.ActionV1
type DomainActionV1 struct {

	// The ID of the customer who created the action
	// Required: true
	Cid *string `json:"cid"`

	// The level of detail in which the content will be delivered. It can be either 'standard' or 'enhanced'
	// Required: true
	ContentFormat *string `json:"content_format"`

	// The date when the action was created
	// Required: true
	// Format: date-time
	CreatedTimestamp *strfmt.DateTime `json:"created_timestamp"`

	// The time interval between the action's triggers. It can be one of the values: 'asap', 'daily' or 'weekly'
	// Required: true
	Frequency *string `json:"frequency"`

	// The ID of the action
	// Required: true
	ID *string `json:"id"`

	// The address list who will be notified by this action.
	// Required: true
	Recipients []string `json:"recipients"`

	// The ID of the rule on which this action is attached
	// Required: true
	RuleID *string `json:"rule_id"`

	// The action status. It can be either 'enabled' or 'muted'.
	// Required: true
	Status *string `json:"status"`

	// Whether to periodically trigger the action based on the frequency, even when there are no new matches for the associated monitoring rule
	// Required: true
	TriggerMatchless *bool `json:"trigger_matchless"`

	// The action type. The only type currently supported is 'email'
	// Required: true
	Type *string `json:"type"`

	// The date when the action was updated
	// Required: true
	// Format: date-time
	UpdatedTimestamp *strfmt.DateTime `json:"updated_timestamp"`

	// The UUID of the user who created the action
	// Required: true
	UserUUID *string `json:"user_uuid"`
}

// Validate validates this domain action v1
func (m *DomainActionV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateContentFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFrequency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRecipients(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRuleID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTriggerMatchless(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainActionV1) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *DomainActionV1) validateContentFormat(formats strfmt.Registry) error {

	if err := validate.Required("content_format", "body", m.ContentFormat); err != nil {
		return err
	}

	return nil
}

func (m *DomainActionV1) validateCreatedTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("created_timestamp", "body", m.CreatedTimestamp); err != nil {
		return err
	}

	if err := validate.FormatOf("created_timestamp", "body", "date-time", m.CreatedTimestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DomainActionV1) validateFrequency(formats strfmt.Registry) error {

	if err := validate.Required("frequency", "body", m.Frequency); err != nil {
		return err
	}

	return nil
}

func (m *DomainActionV1) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *DomainActionV1) validateRecipients(formats strfmt.Registry) error {

	if err := validate.Required("recipients", "body", m.Recipients); err != nil {
		return err
	}

	return nil
}

func (m *DomainActionV1) validateRuleID(formats strfmt.Registry) error {

	if err := validate.Required("rule_id", "body", m.RuleID); err != nil {
		return err
	}

	return nil
}

func (m *DomainActionV1) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *DomainActionV1) validateTriggerMatchless(formats strfmt.Registry) error {

	if err := validate.Required("trigger_matchless", "body", m.TriggerMatchless); err != nil {
		return err
	}

	return nil
}

func (m *DomainActionV1) validateType(formats strfmt.Registry) error {

	if err := validate.Required("type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DomainActionV1) validateUpdatedTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("updated_timestamp", "body", m.UpdatedTimestamp); err != nil {
		return err
	}

	if err := validate.FormatOf("updated_timestamp", "body", "date-time", m.UpdatedTimestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DomainActionV1) validateUserUUID(formats strfmt.Registry) error {

	if err := validate.Required("user_uuid", "body", m.UserUUID); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain action v1 based on context it is used
func (m *DomainActionV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainActionV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainActionV1) UnmarshalBinary(b []byte) error {
	var res DomainActionV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
