// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainActorDocument JSON definition of an Actor, also known as Adversary
//
// swagger:model domain.ActorDocument
type DomainActorDocument struct {

	// Boolean field marking if actor is active
	// Required: true
	Active *bool `json:"active"`

	// Actor type, one of: targeted, ecrime
	ActorType string `json:"actor_type,omitempty"`

	// actor's capabilities, some examples: RAT,Ransomware,Spearphishing,Downloader,Backdoor,InformationStealer,exploit,CredentialHarvesting,dropper,DenialOfService,Loader,Phishing
	// Required: true
	Capabilities []*DomainEntity `json:"capabilities"`

	// Capability of actor's activity, one of: Below Average, Average, Above average
	Capability *DomainEntity `json:"capability,omitempty"`

	// Actor's document creation date when it was added to the Falcon portal in unix timestamp format
	// Required: true
	CreatedDate *int64 `json:"created_date"`

	// Actor's text description, partially containing structured data from other fields
	Description string `json:"description,omitempty"`

	// Multi-field property describing eCrime actor's kill chain
	EcrimeKillChain *DomainECrimeKillChain `json:"ecrime_kill_chain,omitempty"`

	// Field used to filter user's access to actor documents
	Entitlements []*DomainEntity `json:"entitlements"`

	// Actor's first activity observed date in unix timestamp format
	// Required: true
	FirstActivityDate *int64 `json:"first_activity_date"`

	// Deprecated, unused field
	Group *DomainEntity `json:"group,omitempty"`

	// Numerical ID for the Actor
	// Required: true
	ID *int64 `json:"id"`

	// Image used in UI
	Image *DomainImage `json:"image,omitempty"`

	// Multi-field property describing actor's kill chain
	KillChain *DomainKillChain `json:"kill_chain,omitempty"`

	// Alternative names and community identifiers of an actor
	// Required: true
	KnownAs *string `json:"known_as"`

	// Actor's last (most recent) activity observed date in unix timestamp format
	// Required: true
	LastActivityDate *int64 `json:"last_activity_date"`

	// Actor's document last modified date in unix timestamp format
	// Required: true
	LastModifiedDate *int64 `json:"last_modified_date"`

	// Actor's activity motivation, one of: State-Sponsored, Criminal, Hacktivism
	// Required: true
	Motivations []*DomainEntity `json:"motivations"`

	// Actor's name, composed of 2 words
	Name string `json:"name,omitempty"`

	// internal field
	// Required: true
	NotifyUsers *bool `json:"notify_users"`

	// Actor's activity objectives, one of: IntelligenceGathering, FinancialGain, IntellectualPropertyTheft, defacement, Destruction, DenialOfService
	// Required: true
	Objectives []*DomainEntity `json:"objectives"`

	// represents origin of actor's activity and/or members, some examples: China,Russian Federation,Eastern Europe,Iran,East Asia, South Asia
	// Required: true
	Origins []*DomainEntity `json:"origins"`

	// Recent CrowdStrike's finished intelligence alerting date in unix timestamp format
	RecentAlerting int64 `json:"recent_alerting,omitempty"`

	// Deprecated, unused field
	Region *DomainEntity `json:"region,omitempty"`

	// Rich text version of the description field
	RichTextDescription string `json:"rich_text_description,omitempty"`

	// Short version of the description field
	// Required: true
	ShortDescription *string `json:"short_description"`

	// Name in url friendly format, lowercased and spaces replaced with dash
	Slug string `json:"slug,omitempty"`

	// Status of an actor, one of: Active, Inactive, Retired
	// Required: true
	Status *string `json:"status"`

	// Target countries of actor's activity and attacks, slug value is a 2 characters code for the country value, some examples: United States,United Kingdom,Germany,India,Japan,France,Australia,Canada,China
	// Required: true
	TargetCountries []*DomainEntity `json:"target_countries"`

	// Target economical industries of actor's activity and attacks. List of available values: Government, Financial Services, Technology, Telecommunications, Healthcare, Energy, Academic, Media, Aerospace, NGO, Manufacturing, Industrials and Engineering, Retail, Hospitality, Consulting and Professional Services, Opportunistic, Aviation, Defense, Transportation, Oil and Gas, Legal, Pharmaceutical, Logistics, Military, Automotive, Food and Beverage, Consumer Goods, Real Estate, Insurance, Agriculture, Chemicals, Utilities, Maritime, Extractive, Travel, Dissident, Cryptocurrency, Entertainment, National Government, Law Enforcement, Think Tanks, Local Government, Sports Organizations, Computer Gaming, Biomedical, Nonprofit, Financial Management & Hedge Funds, Political Parties, Architectural and Engineering, Emergency Services, Social Media, International Government, Nuclear, Research Entities, Vocational and Higher-Level Education, eCommerce
	// Required: true
	TargetIndustries []*DomainEntity `json:"target_industries"`

	// Target geographic regions of actor's activity and attacks. List of available values: North America, Western Europe, Southeast Asia, Middle East, Eastern Europe, South Asia, South America, Oceania, East Asia, Central Africa, Northern Europe, Southern Europe, North Africa, Southern Africa, Central America, Central Asia, East Africa, West Africa, Caribbean
	// Required: true
	TargetRegions []*DomainEntity `json:"target_regions"`

	// Thumbnail image used in UI
	Thumbnail *DomainImage `json:"thumbnail,omitempty"`

	// URL at which actor profile can be accessed
	URL string `json:"url,omitempty"`
}

// Validate validates this domain actor document
func (m *DomainActorDocument) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActive(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCapabilities(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCapability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEcrimeKillChain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEntitlements(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFirstActivityDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateImage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKillChain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKnownAs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastActivityDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastModifiedDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMotivations(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNotifyUsers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectives(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOrigins(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShortDescription(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTargetCountries(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTargetIndustries(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTargetRegions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThumbnail(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainActorDocument) validateActive(formats strfmt.Registry) error {

	if err := validate.Required("active", "body", m.Active); err != nil {
		return err
	}

	return nil
}

func (m *DomainActorDocument) validateCapabilities(formats strfmt.Registry) error {

	if err := validate.Required("capabilities", "body", m.Capabilities); err != nil {
		return err
	}

	for i := 0; i < len(m.Capabilities); i++ {
		if swag.IsZero(m.Capabilities[i]) { // not required
			continue
		}

		if m.Capabilities[i] != nil {
			if err := m.Capabilities[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("capabilities" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("capabilities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) validateCapability(formats strfmt.Registry) error {
	if swag.IsZero(m.Capability) { // not required
		return nil
	}

	if m.Capability != nil {
		if err := m.Capability.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("capability")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("capability")
			}
			return err
		}
	}

	return nil
}

func (m *DomainActorDocument) validateCreatedDate(formats strfmt.Registry) error {

	if err := validate.Required("created_date", "body", m.CreatedDate); err != nil {
		return err
	}

	return nil
}

func (m *DomainActorDocument) validateEcrimeKillChain(formats strfmt.Registry) error {
	if swag.IsZero(m.EcrimeKillChain) { // not required
		return nil
	}

	if m.EcrimeKillChain != nil {
		if err := m.EcrimeKillChain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ecrime_kill_chain")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ecrime_kill_chain")
			}
			return err
		}
	}

	return nil
}

func (m *DomainActorDocument) validateEntitlements(formats strfmt.Registry) error {
	if swag.IsZero(m.Entitlements) { // not required
		return nil
	}

	for i := 0; i < len(m.Entitlements); i++ {
		if swag.IsZero(m.Entitlements[i]) { // not required
			continue
		}

		if m.Entitlements[i] != nil {
			if err := m.Entitlements[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("entitlements" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("entitlements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) validateFirstActivityDate(formats strfmt.Registry) error {

	if err := validate.Required("first_activity_date", "body", m.FirstActivityDate); err != nil {
		return err
	}

	return nil
}

func (m *DomainActorDocument) validateGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Group) { // not required
		return nil
	}

	if m.Group != nil {
		if err := m.Group.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("group")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("group")
			}
			return err
		}
	}

	return nil
}

func (m *DomainActorDocument) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *DomainActorDocument) validateImage(formats strfmt.Registry) error {
	if swag.IsZero(m.Image) { // not required
		return nil
	}

	if m.Image != nil {
		if err := m.Image.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("image")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("image")
			}
			return err
		}
	}

	return nil
}

func (m *DomainActorDocument) validateKillChain(formats strfmt.Registry) error {
	if swag.IsZero(m.KillChain) { // not required
		return nil
	}

	if m.KillChain != nil {
		if err := m.KillChain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("kill_chain")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("kill_chain")
			}
			return err
		}
	}

	return nil
}

func (m *DomainActorDocument) validateKnownAs(formats strfmt.Registry) error {

	if err := validate.Required("known_as", "body", m.KnownAs); err != nil {
		return err
	}

	return nil
}

func (m *DomainActorDocument) validateLastActivityDate(formats strfmt.Registry) error {

	if err := validate.Required("last_activity_date", "body", m.LastActivityDate); err != nil {
		return err
	}

	return nil
}

func (m *DomainActorDocument) validateLastModifiedDate(formats strfmt.Registry) error {

	if err := validate.Required("last_modified_date", "body", m.LastModifiedDate); err != nil {
		return err
	}

	return nil
}

func (m *DomainActorDocument) validateMotivations(formats strfmt.Registry) error {

	if err := validate.Required("motivations", "body", m.Motivations); err != nil {
		return err
	}

	for i := 0; i < len(m.Motivations); i++ {
		if swag.IsZero(m.Motivations[i]) { // not required
			continue
		}

		if m.Motivations[i] != nil {
			if err := m.Motivations[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("motivations" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("motivations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) validateNotifyUsers(formats strfmt.Registry) error {

	if err := validate.Required("notify_users", "body", m.NotifyUsers); err != nil {
		return err
	}

	return nil
}

func (m *DomainActorDocument) validateObjectives(formats strfmt.Registry) error {

	if err := validate.Required("objectives", "body", m.Objectives); err != nil {
		return err
	}

	for i := 0; i < len(m.Objectives); i++ {
		if swag.IsZero(m.Objectives[i]) { // not required
			continue
		}

		if m.Objectives[i] != nil {
			if err := m.Objectives[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("objectives" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("objectives" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) validateOrigins(formats strfmt.Registry) error {

	if err := validate.Required("origins", "body", m.Origins); err != nil {
		return err
	}

	for i := 0; i < len(m.Origins); i++ {
		if swag.IsZero(m.Origins[i]) { // not required
			continue
		}

		if m.Origins[i] != nil {
			if err := m.Origins[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("origins" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("origins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(m.Region) { // not required
		return nil
	}

	if m.Region != nil {
		if err := m.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("region")
			}
			return err
		}
	}

	return nil
}

func (m *DomainActorDocument) validateShortDescription(formats strfmt.Registry) error {

	if err := validate.Required("short_description", "body", m.ShortDescription); err != nil {
		return err
	}

	return nil
}

func (m *DomainActorDocument) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *DomainActorDocument) validateTargetCountries(formats strfmt.Registry) error {

	if err := validate.Required("target_countries", "body", m.TargetCountries); err != nil {
		return err
	}

	for i := 0; i < len(m.TargetCountries); i++ {
		if swag.IsZero(m.TargetCountries[i]) { // not required
			continue
		}

		if m.TargetCountries[i] != nil {
			if err := m.TargetCountries[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("target_countries" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("target_countries" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) validateTargetIndustries(formats strfmt.Registry) error {

	if err := validate.Required("target_industries", "body", m.TargetIndustries); err != nil {
		return err
	}

	for i := 0; i < len(m.TargetIndustries); i++ {
		if swag.IsZero(m.TargetIndustries[i]) { // not required
			continue
		}

		if m.TargetIndustries[i] != nil {
			if err := m.TargetIndustries[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("target_industries" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("target_industries" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) validateTargetRegions(formats strfmt.Registry) error {

	if err := validate.Required("target_regions", "body", m.TargetRegions); err != nil {
		return err
	}

	for i := 0; i < len(m.TargetRegions); i++ {
		if swag.IsZero(m.TargetRegions[i]) { // not required
			continue
		}

		if m.TargetRegions[i] != nil {
			if err := m.TargetRegions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("target_regions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("target_regions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) validateThumbnail(formats strfmt.Registry) error {
	if swag.IsZero(m.Thumbnail) { // not required
		return nil
	}

	if m.Thumbnail != nil {
		if err := m.Thumbnail.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("thumbnail")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("thumbnail")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this domain actor document based on the context it is used
func (m *DomainActorDocument) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCapabilities(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCapability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEcrimeKillChain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEntitlements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateImage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateKillChain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMotivations(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateObjectives(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOrigins(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTargetCountries(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTargetIndustries(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTargetRegions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThumbnail(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainActorDocument) contextValidateCapabilities(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Capabilities); i++ {

		if m.Capabilities[i] != nil {

			if swag.IsZero(m.Capabilities[i]) { // not required
				return nil
			}

			if err := m.Capabilities[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("capabilities" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("capabilities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) contextValidateCapability(ctx context.Context, formats strfmt.Registry) error {

	if m.Capability != nil {

		if swag.IsZero(m.Capability) { // not required
			return nil
		}

		if err := m.Capability.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("capability")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("capability")
			}
			return err
		}
	}

	return nil
}

func (m *DomainActorDocument) contextValidateEcrimeKillChain(ctx context.Context, formats strfmt.Registry) error {

	if m.EcrimeKillChain != nil {

		if swag.IsZero(m.EcrimeKillChain) { // not required
			return nil
		}

		if err := m.EcrimeKillChain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ecrime_kill_chain")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ecrime_kill_chain")
			}
			return err
		}
	}

	return nil
}

func (m *DomainActorDocument) contextValidateEntitlements(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Entitlements); i++ {

		if m.Entitlements[i] != nil {

			if swag.IsZero(m.Entitlements[i]) { // not required
				return nil
			}

			if err := m.Entitlements[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("entitlements" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("entitlements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) contextValidateGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Group != nil {

		if swag.IsZero(m.Group) { // not required
			return nil
		}

		if err := m.Group.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("group")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("group")
			}
			return err
		}
	}

	return nil
}

func (m *DomainActorDocument) contextValidateImage(ctx context.Context, formats strfmt.Registry) error {

	if m.Image != nil {

		if swag.IsZero(m.Image) { // not required
			return nil
		}

		if err := m.Image.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("image")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("image")
			}
			return err
		}
	}

	return nil
}

func (m *DomainActorDocument) contextValidateKillChain(ctx context.Context, formats strfmt.Registry) error {

	if m.KillChain != nil {

		if swag.IsZero(m.KillChain) { // not required
			return nil
		}

		if err := m.KillChain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("kill_chain")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("kill_chain")
			}
			return err
		}
	}

	return nil
}

func (m *DomainActorDocument) contextValidateMotivations(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Motivations); i++ {

		if m.Motivations[i] != nil {

			if swag.IsZero(m.Motivations[i]) { // not required
				return nil
			}

			if err := m.Motivations[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("motivations" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("motivations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) contextValidateObjectives(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Objectives); i++ {

		if m.Objectives[i] != nil {

			if swag.IsZero(m.Objectives[i]) { // not required
				return nil
			}

			if err := m.Objectives[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("objectives" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("objectives" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) contextValidateOrigins(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Origins); i++ {

		if m.Origins[i] != nil {

			if swag.IsZero(m.Origins[i]) { // not required
				return nil
			}

			if err := m.Origins[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("origins" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("origins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if m.Region != nil {

		if swag.IsZero(m.Region) { // not required
			return nil
		}

		if err := m.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("region")
			}
			return err
		}
	}

	return nil
}

func (m *DomainActorDocument) contextValidateTargetCountries(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.TargetCountries); i++ {

		if m.TargetCountries[i] != nil {

			if swag.IsZero(m.TargetCountries[i]) { // not required
				return nil
			}

			if err := m.TargetCountries[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("target_countries" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("target_countries" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) contextValidateTargetIndustries(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.TargetIndustries); i++ {

		if m.TargetIndustries[i] != nil {

			if swag.IsZero(m.TargetIndustries[i]) { // not required
				return nil
			}

			if err := m.TargetIndustries[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("target_industries" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("target_industries" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) contextValidateTargetRegions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.TargetRegions); i++ {

		if m.TargetRegions[i] != nil {

			if swag.IsZero(m.TargetRegions[i]) { // not required
				return nil
			}

			if err := m.TargetRegions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("target_regions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("target_regions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainActorDocument) contextValidateThumbnail(ctx context.Context, formats strfmt.Registry) error {

	if m.Thumbnail != nil {

		if swag.IsZero(m.Thumbnail) { // not required
			return nil
		}

		if err := m.Thumbnail.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("thumbnail")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("thumbnail")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainActorDocument) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainActorDocument) UnmarshalBinary(b []byte) error {
	var res DomainActorDocument
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
