// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainAPIFindingFacetV1 domain API finding facet v1
//
// swagger:model domain.APIFindingFacetV1
type DomainAPIFindingFacetV1 struct {

	// aid
	// Required: true
	Aid *string `json:"aid"`

	// cid
	// Required: true
	Cid *string `json:"cid"`

	// created timestamp
	// Required: true
	CreatedTimestamp *string `json:"created_timestamp"`

	// finding
	// Required: true
	Finding *DomainAPIFindingWithRuleV1 `json:"finding"`

	// host
	Host *DomainAPIHostInfoFacetV1 `json:"host,omitempty"`

	// id
	// Required: true
	ID *string `json:"id"`

	// logic
	Logic []*DomainAPIEvaluationLogicItemV1 `json:"logic"`

	// updated timestamp
	// Required: true
	UpdatedTimestamp *string `json:"updated_timestamp"`
}

// Validate validates this domain API finding facet v1
func (m *DomainAPIFindingFacetV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFinding(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHost(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogic(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAPIFindingFacetV1) validateAid(formats strfmt.Registry) error {

	if err := validate.Required("aid", "body", m.Aid); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIFindingFacetV1) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIFindingFacetV1) validateCreatedTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("created_timestamp", "body", m.CreatedTimestamp); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIFindingFacetV1) validateFinding(formats strfmt.Registry) error {

	if err := validate.Required("finding", "body", m.Finding); err != nil {
		return err
	}

	if m.Finding != nil {
		if err := m.Finding.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("finding")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("finding")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIFindingFacetV1) validateHost(formats strfmt.Registry) error {
	if swag.IsZero(m.Host) { // not required
		return nil
	}

	if m.Host != nil {
		if err := m.Host.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("host")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("host")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIFindingFacetV1) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIFindingFacetV1) validateLogic(formats strfmt.Registry) error {
	if swag.IsZero(m.Logic) { // not required
		return nil
	}

	for i := 0; i < len(m.Logic); i++ {
		if swag.IsZero(m.Logic[i]) { // not required
			continue
		}

		if m.Logic[i] != nil {
			if err := m.Logic[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("logic" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("logic" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainAPIFindingFacetV1) validateUpdatedTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("updated_timestamp", "body", m.UpdatedTimestamp); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this domain API finding facet v1 based on the context it is used
func (m *DomainAPIFindingFacetV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFinding(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHost(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogic(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAPIFindingFacetV1) contextValidateFinding(ctx context.Context, formats strfmt.Registry) error {

	if m.Finding != nil {

		if err := m.Finding.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("finding")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("finding")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIFindingFacetV1) contextValidateHost(ctx context.Context, formats strfmt.Registry) error {

	if m.Host != nil {

		if swag.IsZero(m.Host) { // not required
			return nil
		}

		if err := m.Host.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("host")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("host")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIFindingFacetV1) contextValidateLogic(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Logic); i++ {

		if m.Logic[i] != nil {

			if swag.IsZero(m.Logic[i]) { // not required
				return nil
			}

			if err := m.Logic[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("logic" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("logic" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainAPIFindingFacetV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainAPIFindingFacetV1) UnmarshalBinary(b []byte) error {
	var res DomainAPIFindingFacetV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
