// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainAPIMitreAttackTacticV1 domain API mitre attack tactic v1
//
// swagger:model domain.APIMitreAttackTacticV1
type DomainAPIMitreAttackTacticV1 struct {

	// id
	// Required: true
	ID *string `json:"id"`

	// link
	Link string `json:"link,omitempty"`

	// techniques
	Techniques []*DomainAPIMitreTechniqueV1 `json:"techniques"`
}

// Validate validates this domain API mitre attack tactic v1
func (m *DomainAPIMitreAttackTacticV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTechniques(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAPIMitreAttackTacticV1) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIMitreAttackTacticV1) validateTechniques(formats strfmt.Registry) error {
	if swag.IsZero(m.Techniques) { // not required
		return nil
	}

	for i := 0; i < len(m.Techniques); i++ {
		if swag.IsZero(m.Techniques[i]) { // not required
			continue
		}

		if m.Techniques[i] != nil {
			if err := m.Techniques[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("techniques" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("techniques" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this domain API mitre attack tactic v1 based on the context it is used
func (m *DomainAPIMitreAttackTacticV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateTechniques(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAPIMitreAttackTacticV1) contextValidateTechniques(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Techniques); i++ {

		if m.Techniques[i] != nil {

			if swag.IsZero(m.Techniques[i]) { // not required
				return nil
			}

			if err := m.Techniques[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("techniques" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("techniques" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainAPIMitreAttackTacticV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainAPIMitreAttackTacticV1) UnmarshalBinary(b []byte) error {
	var res DomainAPIMitreAttackTacticV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
