// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainAPIVulnerabilityCVEDetailsFacetV2 domain API vulnerability c v e details facet v2
//
// swagger:model domain.APIVulnerabilityCVEDetailsFacetV2
type DomainAPIVulnerabilityCVEDetailsFacetV2 struct {

	// Contains a list of actors that are known for exploiting this vulnerability ot in the wild
	Actors []string `json:"actors"`

	// The base score for a Common Vulnerability Enumeration (CVE) is a numerical value that represents the intrinsic severity and impact of a security vulnerability.
	BaseScore float64 `json:"base_score,omitempty"`

	// CISA_info encompasses cybersecurity alerts and guidance provided by the Cybersecurity and Infrastructure Security Agency (CISA) for enhancing critical infrastructure resilience
	CisaInfo *DomainAPIVulnerabilityCVECISAInfo `json:"cisa_info,omitempty"`

	// Refers to description of the vulnerability
	Description string `json:"description,omitempty"`

	// Exploit status refers to the current state or availability of known exploits for a specific vulnerability, indicating whether there are known techniques or tools to leverage the vulnerability in an attack.
	ExploitStatus int64 `json:"exploit_status,omitempty"`

	// Represents a numerical value that indicates the relative ease or difficulty for an attacker to exploit a vulnerability
	ExploitabilityScore float64 `json:"exploitability_score,omitempty"`

	// Expert.AI score on the vulnerability
	ExprtRating string `json:"exprt_rating,omitempty"`

	// id
	// Required: true
	ID *string `json:"id"`

	// Refers to a numerical value that represents the potential impact or severity of a vulnerability when it is successfully exploited
	ImpactScore float64 `json:"impact_score,omitempty"`

	// Vulnerability name
	Name string `json:"name,omitempty"`

	// Refers to a point in time when the vulnerability has been disclosed
	PublishedDate string `json:"published_date,omitempty"`

	// Refers to one or more references with more details about the vulnerability
	References []string `json:"references"`

	// Remediation level indicates the required effort to mitigate a security vulnerability, ranging from official fixes to unavailable remedies
	RemediationLevel string `json:"remediation_level,omitempty"`

	// Severity refers to the level of impact or potential harm caused by a security vulnerability. It is often assessed using metrics such as the CVSS base score, which takes into account factors such as exploitability, impact on confidentiality, integrity, and availability, and other relevant parameters to determine the severity level of a vulnerability.
	Severity string `json:"severity,omitempty"`

	// Corresponds to a point in time when Spotlight offered support for detecting a specific vulnerability
	SpotlightPublishedDate string `json:"spotlight_published_date,omitempty"`

	// Refers to the vector of attack or the specific method or path through which an attacker can exploit a vulnerability
	Vector string `json:"vector,omitempty"`

	// Refers to one or more URLs that points to vendor advisories
	VendorAdvisory []string `json:"vendor_advisory"`
}

// Validate validates this domain API vulnerability c v e details facet v2
func (m *DomainAPIVulnerabilityCVEDetailsFacetV2) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCisaInfo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAPIVulnerabilityCVEDetailsFacetV2) validateCisaInfo(formats strfmt.Registry) error {
	if swag.IsZero(m.CisaInfo) { // not required
		return nil
	}

	if m.CisaInfo != nil {
		if err := m.CisaInfo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cisa_info")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cisa_info")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIVulnerabilityCVEDetailsFacetV2) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this domain API vulnerability c v e details facet v2 based on the context it is used
func (m *DomainAPIVulnerabilityCVEDetailsFacetV2) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCisaInfo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAPIVulnerabilityCVEDetailsFacetV2) contextValidateCisaInfo(ctx context.Context, formats strfmt.Registry) error {

	if m.CisaInfo != nil {

		if swag.IsZero(m.CisaInfo) { // not required
			return nil
		}

		if err := m.CisaInfo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cisa_info")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cisa_info")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainAPIVulnerabilityCVEDetailsFacetV2) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainAPIVulnerabilityCVEDetailsFacetV2) UnmarshalBinary(b []byte) error {
	var res DomainAPIVulnerabilityCVEDetailsFacetV2
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
