// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainAPIVulnerabilityExtendedAppV2 domain API vulnerability extended app v2
//
// swagger:model domain.APIVulnerabilityExtendedAppV2
type DomainAPIVulnerabilityExtendedAppV2 struct {

	// Contains specific evaluation logic info for the vulnerability, affecting this specific product
	EvaluationLogic *DomainAPIEvaluationLogicV1 `json:"evaluation_logic,omitempty"`

	// product name version
	// Required: true
	ProductNameVersion *string `json:"product_name_version"`

	// Contains specific remediation details for the vulnerability, affecting this specific product
	Remediation *DomainAPIRemediationIDs `json:"remediation,omitempty"`

	// Contains vulnerability status for a particular product - can differentiate in cases where a vulnerability is detected for multiple products
	SubStatus string `json:"sub_status,omitempty"`
}

// Validate validates this domain API vulnerability extended app v2
func (m *DomainAPIVulnerabilityExtendedAppV2) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEvaluationLogic(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProductNameVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemediation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAPIVulnerabilityExtendedAppV2) validateEvaluationLogic(formats strfmt.Registry) error {
	if swag.IsZero(m.EvaluationLogic) { // not required
		return nil
	}

	if m.EvaluationLogic != nil {
		if err := m.EvaluationLogic.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("evaluation_logic")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("evaluation_logic")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIVulnerabilityExtendedAppV2) validateProductNameVersion(formats strfmt.Registry) error {

	if err := validate.Required("product_name_version", "body", m.ProductNameVersion); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIVulnerabilityExtendedAppV2) validateRemediation(formats strfmt.Registry) error {
	if swag.IsZero(m.Remediation) { // not required
		return nil
	}

	if m.Remediation != nil {
		if err := m.Remediation.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remediation")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("remediation")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this domain API vulnerability extended app v2 based on the context it is used
func (m *DomainAPIVulnerabilityExtendedAppV2) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEvaluationLogic(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemediation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAPIVulnerabilityExtendedAppV2) contextValidateEvaluationLogic(ctx context.Context, formats strfmt.Registry) error {

	if m.EvaluationLogic != nil {

		if swag.IsZero(m.EvaluationLogic) { // not required
			return nil
		}

		if err := m.EvaluationLogic.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("evaluation_logic")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("evaluation_logic")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIVulnerabilityExtendedAppV2) contextValidateRemediation(ctx context.Context, formats strfmt.Registry) error {

	if m.Remediation != nil {

		if swag.IsZero(m.Remediation) { // not required
			return nil
		}

		if err := m.Remediation.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remediation")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("remediation")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainAPIVulnerabilityExtendedAppV2) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainAPIVulnerabilityExtendedAppV2) UnmarshalBinary(b []byte) error {
	var res DomainAPIVulnerabilityExtendedAppV2
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
