// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainAPIVulnerabilityHostFacetV2 domain API vulnerability host facet v2
//
// swagger:model domain.APIVulnerabilityHostFacetV2
type DomainAPIVulnerabilityHostFacetV2 struct {

	// Refers to how critical an asset has been evaluated to be
	AssetCriticality string `json:"asset_criticality,omitempty"`

	// Refers to one or more roles that have been assigned to the assets
	AssetRoles []string `json:"asset_roles"`

	// A unique identifier assigned by entity graph
	EntityGraphID string `json:"entity_graph_id,omitempty"`

	// Refers to a logic grouping of assets
	Groups []*DomainAPIHostGroup `json:"groups"`

	// A timestamp corresponding to the last day when we detected activity coming from an asset
	HostLastSeenTimestamp string `json:"host_last_seen_timestamp,omitempty"`

	// Refers to the hostname used by the asset on which the vulnerability was detected
	// Required: true
	Hostname *string `json:"hostname"`

	// Refers to a unique identifier assigned to an asset
	InstanceID string `json:"instance_id,omitempty"`

	// Refers to the level of exposure an asset has to the internet
	InternetExposure string `json:"internet_exposure,omitempty"`

	// Refers to the local IP used by the asset on which the vulnerability was detected
	// Required: true
	LocalIP *string `json:"local_ip"`

	// The machine domain of an asset is the network identity within a network infrastructure
	// Required: true
	MachineDomain *string `json:"machine_domain"`

	// Name of the entity that is managing the asset
	ManagedBy string `json:"managed_by,omitempty"`

	// Refers to the specific build or version number of an operating system, indicating a particular release or revision of the operating system
	OsBuild string `json:"os_build,omitempty"`

	// Refers to the operating system version used by the asset on which the vulnerability was detected
	// Required: true
	OsVersion *string `json:"os_version"`

	// Refers to the specific organizational grouping or container within an Active Directory (AD) or directory service where the host is located or categorized.
	// Required: true
	Ou *string `json:"ou"`

	// Refers to the name or designation of the specific software platform or operating system on which the asset is running
	Platform string `json:"platform,omitempty"`

	// Refers to the descriptive label or category that identifies the type or edition of the operating system product installed on the asset
	ProductTypeDesc string `json:"product_type_desc,omitempty"`

	// Refers to a company, organization, or entity that offers or provided this specific asset
	ServiceProvider string `json:"service_provider,omitempty"`

	// Refers to the unique identifier associated with a service provider account, typically used in cloud computing or managed service environments
	ServiceProviderAccountID string `json:"service_provider_account_id,omitempty"`

	// Refers to the name or label assigned to the physical or logical location within a network infrastructure where the host is situated
	// Required: true
	SiteName *string `json:"site_name"`

	// Refers to the company or organization that designed and produced the hardware system or device
	// Required: true
	SystemManufacturer *string `json:"system_manufacturer"`

	// Refers to a logical grouping of assets via tags
	Tags []string `json:"tags"`

	// zero or more unique identifiers assigned by third party entities which provided data for the asset
	ThirdPartyAssetIds []string `json:"third_party_asset_ids"`
}

// Validate validates this domain API vulnerability host facet v2
func (m *DomainAPIVulnerabilityHostFacetV2) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHostname(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocalIP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMachineDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOu(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSiteName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSystemManufacturer(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAPIVulnerabilityHostFacetV2) validateGroups(formats strfmt.Registry) error {
	if swag.IsZero(m.Groups) { // not required
		return nil
	}

	for i := 0; i < len(m.Groups); i++ {
		if swag.IsZero(m.Groups[i]) { // not required
			continue
		}

		if m.Groups[i] != nil {
			if err := m.Groups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("groups" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainAPIVulnerabilityHostFacetV2) validateHostname(formats strfmt.Registry) error {

	if err := validate.Required("hostname", "body", m.Hostname); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIVulnerabilityHostFacetV2) validateLocalIP(formats strfmt.Registry) error {

	if err := validate.Required("local_ip", "body", m.LocalIP); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIVulnerabilityHostFacetV2) validateMachineDomain(formats strfmt.Registry) error {

	if err := validate.Required("machine_domain", "body", m.MachineDomain); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIVulnerabilityHostFacetV2) validateOsVersion(formats strfmt.Registry) error {

	if err := validate.Required("os_version", "body", m.OsVersion); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIVulnerabilityHostFacetV2) validateOu(formats strfmt.Registry) error {

	if err := validate.Required("ou", "body", m.Ou); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIVulnerabilityHostFacetV2) validateSiteName(formats strfmt.Registry) error {

	if err := validate.Required("site_name", "body", m.SiteName); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIVulnerabilityHostFacetV2) validateSystemManufacturer(formats strfmt.Registry) error {

	if err := validate.Required("system_manufacturer", "body", m.SystemManufacturer); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this domain API vulnerability host facet v2 based on the context it is used
func (m *DomainAPIVulnerabilityHostFacetV2) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAPIVulnerabilityHostFacetV2) contextValidateGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Groups); i++ {

		if m.Groups[i] != nil {

			if swag.IsZero(m.Groups[i]) { // not required
				return nil
			}

			if err := m.Groups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("groups" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainAPIVulnerabilityHostFacetV2) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainAPIVulnerabilityHostFacetV2) UnmarshalBinary(b []byte) error {
	var res DomainAPIVulnerabilityHostFacetV2
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
