// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainAPIVulnerabilityV2 domain API vulnerability v2
//
// swagger:model domain.APIVulnerabilityV2
type DomainAPIVulnerabilityV2 struct {

	// Asset ID for which the vulnerability has been detected. For managed assets it can correspond to the sensor ID, for unmanaged assets can be a stand alone ID
	// Required: true
	Aid *string `json:"aid"`

	// Provide details related to the product for which a the vulnerability has been detected
	App *DomainAPIVulnerabilityAppV2 `json:"app,omitempty"`

	// Provide details related to the products for which a the vulnerability has been detected
	Apps []*DomainAPIVulnerabilityExtendedAppV2 `json:"apps"`

	// Contains the customer identifier associated with the asset for which the vulnerability has been detected
	// Required: true
	Cid *string `json:"cid"`

	// A timestamp corresponding to the point in time when the vulnerability has no longer been detected (eg: it got fixed)
	ClosedTimestamp string `json:"closed_timestamp,omitempty"`

	// A timestamp corresponding to the point in time when the vulnerability has been created (detected) in our system
	// Required: true
	CreatedTimestamp *string `json:"created_timestamp"`

	// cve
	Cve *DomainAPIVulnerabilityCVEDetailsFacetV2 `json:"cve,omitempty"`

	// Contains information about the vulnerability data providers of this entity
	DataProviders []*DomainAPIVulnerabilityDataProviderV1 `json:"data_providers"`

	// host info
	HostInfo *DomainAPIVulnerabilityHostFacetV2 `json:"host_info,omitempty"`

	// Vulnerability unique ID
	// Required: true
	ID *string `json:"id"`

	// Contains ports that the vulnerability affects
	Ports []int64 `json:"ports"`

	// remediation
	Remediation *DomainAPIVulnerabilityRemediationFacetV2 `json:"remediation,omitempty"`

	// Current status of a vulnerability (open, closed, reopen)
	// Required: true
	Status *string `json:"status"`

	// Contains details that can explain if and why a vulnerability has been suppressed
	SuppressionInfo *DomainAPIVulnerabilitySuppressionInfoV2 `json:"suppression_info,omitempty"`

	// A timestamp corresponding to the point in time when a vulnerability's information or status have been updated
	// Required: true
	UpdatedTimestamp *string `json:"updated_timestamp"`

	// Dynamic label that contains the CVE ID if applicable, otherwise the vulnerability metadata ID or label from the provider
	VulnerabilityID string `json:"vulnerability_id,omitempty"`

	// Unique identifier for the vulnerability metadata
	VulnerabilityMetadataID string `json:"vulnerability_metadata_id,omitempty"`
}

// Validate validates this domain API vulnerability v2
func (m *DomainAPIVulnerabilityV2) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCve(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataProviders(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHostInfo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemediation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSuppressionInfo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAPIVulnerabilityV2) validateAid(formats strfmt.Registry) error {

	if err := validate.Required("aid", "body", m.Aid); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) validateApp(formats strfmt.Registry) error {
	if swag.IsZero(m.App) { // not required
		return nil
	}

	if m.App != nil {
		if err := m.App.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("app")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("app")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) validateApps(formats strfmt.Registry) error {
	if swag.IsZero(m.Apps) { // not required
		return nil
	}

	for i := 0; i < len(m.Apps); i++ {
		if swag.IsZero(m.Apps[i]) { // not required
			continue
		}

		if m.Apps[i] != nil {
			if err := m.Apps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("apps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("apps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) validateCreatedTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("created_timestamp", "body", m.CreatedTimestamp); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) validateCve(formats strfmt.Registry) error {
	if swag.IsZero(m.Cve) { // not required
		return nil
	}

	if m.Cve != nil {
		if err := m.Cve.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cve")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cve")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) validateDataProviders(formats strfmt.Registry) error {
	if swag.IsZero(m.DataProviders) { // not required
		return nil
	}

	for i := 0; i < len(m.DataProviders); i++ {
		if swag.IsZero(m.DataProviders[i]) { // not required
			continue
		}

		if m.DataProviders[i] != nil {
			if err := m.DataProviders[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data_providers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("data_providers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) validateHostInfo(formats strfmt.Registry) error {
	if swag.IsZero(m.HostInfo) { // not required
		return nil
	}

	if m.HostInfo != nil {
		if err := m.HostInfo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("host_info")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("host_info")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) validateRemediation(formats strfmt.Registry) error {
	if swag.IsZero(m.Remediation) { // not required
		return nil
	}

	if m.Remediation != nil {
		if err := m.Remediation.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remediation")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("remediation")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) validateSuppressionInfo(formats strfmt.Registry) error {
	if swag.IsZero(m.SuppressionInfo) { // not required
		return nil
	}

	if m.SuppressionInfo != nil {
		if err := m.SuppressionInfo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("suppression_info")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("suppression_info")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) validateUpdatedTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("updated_timestamp", "body", m.UpdatedTimestamp); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this domain API vulnerability v2 based on the context it is used
func (m *DomainAPIVulnerabilityV2) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCve(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataProviders(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHostInfo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemediation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSuppressionInfo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAPIVulnerabilityV2) contextValidateApp(ctx context.Context, formats strfmt.Registry) error {

	if m.App != nil {

		if swag.IsZero(m.App) { // not required
			return nil
		}

		if err := m.App.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("app")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("app")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) contextValidateApps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Apps); i++ {

		if m.Apps[i] != nil {

			if swag.IsZero(m.Apps[i]) { // not required
				return nil
			}

			if err := m.Apps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("apps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("apps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) contextValidateCve(ctx context.Context, formats strfmt.Registry) error {

	if m.Cve != nil {

		if swag.IsZero(m.Cve) { // not required
			return nil
		}

		if err := m.Cve.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cve")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cve")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) contextValidateDataProviders(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataProviders); i++ {

		if m.DataProviders[i] != nil {

			if swag.IsZero(m.DataProviders[i]) { // not required
				return nil
			}

			if err := m.DataProviders[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data_providers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("data_providers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) contextValidateHostInfo(ctx context.Context, formats strfmt.Registry) error {

	if m.HostInfo != nil {

		if swag.IsZero(m.HostInfo) { // not required
			return nil
		}

		if err := m.HostInfo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("host_info")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("host_info")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) contextValidateRemediation(ctx context.Context, formats strfmt.Registry) error {

	if m.Remediation != nil {

		if swag.IsZero(m.Remediation) { // not required
			return nil
		}

		if err := m.Remediation.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remediation")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("remediation")
			}
			return err
		}
	}

	return nil
}

func (m *DomainAPIVulnerabilityV2) contextValidateSuppressionInfo(ctx context.Context, formats strfmt.Registry) error {

	if m.SuppressionInfo != nil {

		if swag.IsZero(m.SuppressionInfo) { // not required
			return nil
		}

		if err := m.SuppressionInfo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("suppression_info")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("suppression_info")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainAPIVulnerabilityV2) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainAPIVulnerabilityV2) UnmarshalBinary(b []byte) error {
	var res DomainAPIVulnerabilityV2
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
