// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainAssessmentItems domain assessment items
//
// swagger:model domain.AssessmentItems
type DomainAssessmentItems struct {

	// os signals
	// Required: true
	OsSignals []*DomainSignalProperty `json:"os_signals"`

	// sensor signals
	// Required: true
	SensorSignals []*DomainSignalProperty `json:"sensor_signals"`
}

// Validate validates this domain assessment items
func (m *DomainAssessmentItems) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateOsSignals(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSensorSignals(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAssessmentItems) validateOsSignals(formats strfmt.Registry) error {

	if err := validate.Required("os_signals", "body", m.OsSignals); err != nil {
		return err
	}

	for i := 0; i < len(m.OsSignals); i++ {
		if swag.IsZero(m.OsSignals[i]) { // not required
			continue
		}

		if m.OsSignals[i] != nil {
			if err := m.OsSignals[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("os_signals" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("os_signals" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainAssessmentItems) validateSensorSignals(formats strfmt.Registry) error {

	if err := validate.Required("sensor_signals", "body", m.SensorSignals); err != nil {
		return err
	}

	for i := 0; i < len(m.SensorSignals); i++ {
		if swag.IsZero(m.SensorSignals[i]) { // not required
			continue
		}

		if m.SensorSignals[i] != nil {
			if err := m.SensorSignals[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("sensor_signals" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("sensor_signals" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this domain assessment items based on the context it is used
func (m *DomainAssessmentItems) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateOsSignals(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSensorSignals(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAssessmentItems) contextValidateOsSignals(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.OsSignals); i++ {

		if m.OsSignals[i] != nil {

			if swag.IsZero(m.OsSignals[i]) { // not required
				return nil
			}

			if err := m.OsSignals[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("os_signals" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("os_signals" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainAssessmentItems) contextValidateSensorSignals(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SensorSignals); i++ {

		if m.SensorSignals[i] != nil {

			if swag.IsZero(m.SensorSignals[i]) { // not required
				return nil
			}

			if err := m.SensorSignals[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("sensor_signals" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("sensor_signals" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainAssessmentItems) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainAssessmentItems) UnmarshalBinary(b []byte) error {
	var res DomainAssessmentItems
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
