// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainAzureClientServicePrincipalV1 domain azure client service principal v1
//
// swagger:model domain.AzureClientServicePrincipalV1
type DomainAzureClientServicePrincipalV1 struct {

	// account type
	AccountType string `json:"account_type,omitempty"`

	// behavior assessment override
	BehaviorAssessmentOverride bool `json:"behavior_assessment_override,omitempty"`

	// cid
	// Required: true
	Cid *string `json:"cid"`

	// client id
	ClientID string `json:"client_id,omitempty"`

	// conditions
	Conditions []*DomainCondition `json:"conditions"`

	// If the account has CSPM enabled.
	// Required: true
	CspmEnabled *bool `json:"cspm_enabled"`

	// default subscription id
	DefaultSubscriptionID string `json:"default_subscription_id,omitempty"`

	// encrypted private key
	EncryptedPrivateKey string `json:"encrypted_private_key,omitempty"`

	// object id
	ObjectID string `json:"object_id,omitempty"`

	// public certificate
	PublicCertificate string `json:"public_certificate,omitempty"`

	// resource permissions
	ResourcePermissions []*DomainAzureResourcePermission `json:"resource_permissions"`

	// tenant id
	// Required: true
	TenantID *string `json:"tenant_id"`

	// x5t
	X5t string `json:"x5t,omitempty"`
}

// Validate validates this domain azure client service principal v1
func (m *DomainAzureClientServicePrincipalV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConditions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCspmEnabled(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResourcePermissions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTenantID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAzureClientServicePrincipalV1) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *DomainAzureClientServicePrincipalV1) validateConditions(formats strfmt.Registry) error {
	if swag.IsZero(m.Conditions) { // not required
		return nil
	}

	for i := 0; i < len(m.Conditions); i++ {
		if swag.IsZero(m.Conditions[i]) { // not required
			continue
		}

		if m.Conditions[i] != nil {
			if err := m.Conditions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainAzureClientServicePrincipalV1) validateCspmEnabled(formats strfmt.Registry) error {

	if err := validate.Required("cspm_enabled", "body", m.CspmEnabled); err != nil {
		return err
	}

	return nil
}

func (m *DomainAzureClientServicePrincipalV1) validateResourcePermissions(formats strfmt.Registry) error {
	if swag.IsZero(m.ResourcePermissions) { // not required
		return nil
	}

	for i := 0; i < len(m.ResourcePermissions); i++ {
		if swag.IsZero(m.ResourcePermissions[i]) { // not required
			continue
		}

		if m.ResourcePermissions[i] != nil {
			if err := m.ResourcePermissions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("resource_permissions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("resource_permissions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainAzureClientServicePrincipalV1) validateTenantID(formats strfmt.Registry) error {

	if err := validate.Required("tenant_id", "body", m.TenantID); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this domain azure client service principal v1 based on the context it is used
func (m *DomainAzureClientServicePrincipalV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConditions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResourcePermissions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainAzureClientServicePrincipalV1) contextValidateConditions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Conditions); i++ {

		if m.Conditions[i] != nil {

			if swag.IsZero(m.Conditions[i]) { // not required
				return nil
			}

			if err := m.Conditions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainAzureClientServicePrincipalV1) contextValidateResourcePermissions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ResourcePermissions); i++ {

		if m.ResourcePermissions[i] != nil {

			if swag.IsZero(m.ResourcePermissions[i]) { // not required
				return nil
			}

			if err := m.ResourcePermissions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("resource_permissions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("resource_permissions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainAzureClientServicePrincipalV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainAzureClientServicePrincipalV1) UnmarshalBinary(b []byte) error {
	var res DomainAzureClientServicePrincipalV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
